/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CodeDeliveryDetailsType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeDeliveryDetailsTypeMarshaller {
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destination").isBinary(false).build();
    private static final MarshallingInfo<String> DELIVERYMEDIUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryMedium").isBinary(false).build();
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").isBinary(false).build();
    private static final CodeDeliveryDetailsTypeMarshaller INSTANCE = new CodeDeliveryDetailsTypeMarshaller();

    private CodeDeliveryDetailsTypeMarshaller() {
    }

    public static CodeDeliveryDetailsTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeDeliveryDetailsType codeDeliveryDetailsType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeDeliveryDetailsType, (String)"codeDeliveryDetailsType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeDeliveryDetailsType.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)codeDeliveryDetailsType.deliveryMediumAsString(), DELIVERYMEDIUM_BINDING);
            protocolMarshaller.marshall((Object)codeDeliveryDetailsType.attributeName(), ATTRIBUTENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

