/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminRespondToAuthChallengeRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AdminRespondToAuthChallengeRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> CHALLENGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChallengeName").isBinary(false).build();
    private static final MarshallingInfo<Map> CHALLENGERESPONSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChallengeResponses").isBinary(false).build();
    private static final MarshallingInfo<String> SESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Session").isBinary(false).build();
    private static final AdminRespondToAuthChallengeRequestModelMarshaller INSTANCE = new AdminRespondToAuthChallengeRequestModelMarshaller();

    private AdminRespondToAuthChallengeRequestModelMarshaller() {
    }

    public static AdminRespondToAuthChallengeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AdminRespondToAuthChallengeRequest adminRespondToAuthChallengeRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)adminRespondToAuthChallengeRequest), (String)"adminRespondToAuthChallengeRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)adminRespondToAuthChallengeRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)adminRespondToAuthChallengeRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)adminRespondToAuthChallengeRequest.challengeNameAsString(), CHALLENGENAME_BINDING);
            protocolMarshaller.marshall(adminRespondToAuthChallengeRequest.challengeResponses(), CHALLENGERESPONSES_BINDING);
            protocolMarshaller.marshall((Object)adminRespondToAuthChallengeRequest.session(), SESSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

