/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminInitiateAuthRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AdminInitiateAuthRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHFLOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthFlow").isBinary(false).build();
    private static final MarshallingInfo<Map> AUTHPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> CLIENTMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientMetadata").isBinary(false).build();
    private static final AdminInitiateAuthRequestModelMarshaller INSTANCE = new AdminInitiateAuthRequestModelMarshaller();

    private AdminInitiateAuthRequestModelMarshaller() {
    }

    public static AdminInitiateAuthRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AdminInitiateAuthRequest adminInitiateAuthRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)adminInitiateAuthRequest), (String)"adminInitiateAuthRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)adminInitiateAuthRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)adminInitiateAuthRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)adminInitiateAuthRequest.authFlowAsString(), AUTHFLOW_BINDING);
            protocolMarshaller.marshall(adminInitiateAuthRequest.authParameters(), AUTHPARAMETERS_BINDING);
            protocolMarshaller.marshall(adminInitiateAuthRequest.clientMetadata(), CLIENTMETADATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

