/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminGetDeviceRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AdminGetDeviceRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AdminGetDeviceRequestMarshaller
implements Marshaller<Request<AdminGetDeviceRequest>, AdminGetDeviceRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSCognitoIdentityProviderService.AdminGetDevice").serviceName("Amazon Cognito Identity Provider").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public AdminGetDeviceRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AdminGetDeviceRequest> marshall(AdminGetDeviceRequest adminGetDeviceRequest) {
        Validate.paramNotNull((Object)((Object)adminGetDeviceRequest), (String)"adminGetDeviceRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)adminGetDeviceRequest);
            protocolMarshaller.startMarshalling();
            AdminGetDeviceRequestModelMarshaller.getInstance().marshall(adminGetDeviceRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

