/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AdminCreateUserRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<List> USERATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> VALIDATIONDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationData").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPORARYPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemporaryPassword").isBinary(false).build();
    private static final MarshallingInfo<Boolean> FORCEALIASCREATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForceAliasCreation").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGEACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageAction").isBinary(false).build();
    private static final MarshallingInfo<List> DESIREDDELIVERYMEDIUMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredDeliveryMediums").isBinary(false).build();
    private static final AdminCreateUserRequestModelMarshaller INSTANCE = new AdminCreateUserRequestModelMarshaller();

    private AdminCreateUserRequestModelMarshaller() {
    }

    public static AdminCreateUserRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AdminCreateUserRequest adminCreateUserRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)adminCreateUserRequest), (String)"adminCreateUserRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)adminCreateUserRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)adminCreateUserRequest.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.userAttributes(), USERATTRIBUTES_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.validationData(), VALIDATIONDATA_BINDING);
            protocolMarshaller.marshall((Object)adminCreateUserRequest.temporaryPassword(), TEMPORARYPASSWORD_BINDING);
            protocolMarshaller.marshall((Object)adminCreateUserRequest.forceAliasCreation(), FORCEALIASCREATION_BINDING);
            protocolMarshaller.marshall((Object)adminCreateUserRequest.messageActionAsString(), MESSAGEACTION_BINDING);
            protocolMarshaller.marshall(adminCreateUserRequest.desiredDeliveryMediumsAsStrings(), DESIREDDELIVERYMEDIUMS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

