/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AddCustomAttributesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AddCustomAttributesRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<List> CUSTOMATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomAttributes").isBinary(false).build();
    private static final AddCustomAttributesRequestModelMarshaller INSTANCE = new AddCustomAttributesRequestModelMarshaller();

    private AddCustomAttributesRequestModelMarshaller() {
    }

    public static AddCustomAttributesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AddCustomAttributesRequest addCustomAttributesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)addCustomAttributesRequest), (String)"addCustomAttributesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)addCustomAttributesRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(addCustomAttributesRequest.customAttributes(), CUSTOMATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

