/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyUserAttributeRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, VerifyUserAttributeRequest> {
    private final String accessToken;
    private final String attributeName;
    private final String code;

    private VerifyUserAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.attributeName = builder.attributeName;
        this.code = builder.code;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String code() {
        return this.code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyUserAttributeRequest)) {
            return false;
        }
        VerifyUserAttributeRequest other = (VerifyUserAttributeRequest)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.code(), other.code());
    }

    public String toString() {
        return ToString.builder((String)"VerifyUserAttributeRequest").add("AccessToken", (Object)this.accessToken()).add("AttributeName", (Object)this.attributeName()).add("Code", (Object)this.code()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String accessToken;
        private String attributeName;
        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyUserAttributeRequest model) {
            super(model);
            this.accessToken(model.accessToken);
            this.attributeName(model.attributeName);
            this.code(model.code);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyUserAttributeRequest build() {
            return new VerifyUserAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, VerifyUserAttributeRequest> {
        public Builder accessToken(String var1);

        public Builder attributeName(String var1);

        public Builder code(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

