/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserStatusType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UserTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserType
implements StructuredPojo,
ToCopyableBuilder<Builder, UserType> {
    private final String username;
    private final List<AttributeType> attributes;
    private final Instant userCreateDate;
    private final Instant userLastModifiedDate;
    private final Boolean enabled;
    private final String userStatus;
    private final List<MFAOptionType> mfaOptions;

    private UserType(BuilderImpl builder) {
        this.username = builder.username;
        this.attributes = builder.attributes;
        this.userCreateDate = builder.userCreateDate;
        this.userLastModifiedDate = builder.userLastModifiedDate;
        this.enabled = builder.enabled;
        this.userStatus = builder.userStatus;
        this.mfaOptions = builder.mfaOptions;
    }

    public String username() {
        return this.username;
    }

    public List<AttributeType> attributes() {
        return this.attributes;
    }

    public Instant userCreateDate() {
        return this.userCreateDate;
    }

    public Instant userLastModifiedDate() {
        return this.userLastModifiedDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public UserStatusType userStatus() {
        return UserStatusType.fromValue(this.userStatus);
    }

    public String userStatusAsString() {
        return this.userStatus;
    }

    public List<MFAOptionType> mfaOptions() {
        return this.mfaOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.userLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.userStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.userCreateDate(), other.userCreateDate()) && Objects.equals(this.userLastModifiedDate(), other.userLastModifiedDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.userStatusAsString(), other.userStatusAsString()) && Objects.equals(this.mfaOptions(), other.mfaOptions());
    }

    public String toString() {
        return ToString.builder((String)"UserType").add("Username", (Object)this.username()).add("Attributes", this.attributes()).add("UserCreateDate", (Object)this.userCreateDate()).add("UserLastModifiedDate", (Object)this.userLastModifiedDate()).add("Enabled", (Object)this.enabled()).add("UserStatus", (Object)this.userStatusAsString()).add("MFAOptions", this.mfaOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "UserCreateDate": {
                return Optional.ofNullable(clazz.cast(this.userCreateDate()));
            }
            case "UserLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.userLastModifiedDate()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "UserStatus": {
                return Optional.ofNullable(clazz.cast(this.userStatusAsString()));
            }
            case "MFAOptions": {
                return Optional.ofNullable(clazz.cast(this.mfaOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private List<AttributeType> attributes = DefaultSdkAutoConstructList.getInstance();
        private Instant userCreateDate;
        private Instant userLastModifiedDate;
        private Boolean enabled;
        private String userStatus;
        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserType model) {
            this.username(model.username);
            this.attributes(model.attributes);
            this.userCreateDate(model.userCreateDate);
            this.userLastModifiedDate(model.userLastModifiedDate);
            this.enabled(model.enabled);
            this.userStatus(model.userStatus);
            this.mfaOptions(model.mfaOptions);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeType> attributes) {
            this.attributes = AttributeListTypeCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeType ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeType.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeType.BuilderImpl> attributes) {
            this.attributes = AttributeListTypeCopier.copyFromBuilder(attributes);
        }

        public final Instant getUserCreateDate() {
            return this.userCreateDate;
        }

        @Override
        public final Builder userCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
            return this;
        }

        public final void setUserCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
        }

        public final Instant getUserLastModifiedDate() {
            return this.userLastModifiedDate;
        }

        @Override
        public final Builder userLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
            return this;
        }

        public final void setUserLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getUserStatus() {
            return this.userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatusType userStatus) {
            this.userStatus(userStatus.toString());
            return this;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        public final Collection<MFAOptionType.Builder> getMFAOptions() {
            return this.mfaOptions != null ? (Collection)this.mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType ... mfaOptions) {
            this.mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder> ... mfaOptions) {
            this.mfaOptions(Stream.of(mfaOptions).map(c -> (MFAOptionType)((MFAOptionType.Builder)MFAOptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMFAOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        public UserType build() {
            return new UserType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserType> {
        public Builder username(String var1);

        public Builder attributes(Collection<AttributeType> var1);

        public Builder attributes(AttributeType ... var1);

        public Builder attributes(Consumer<AttributeType.Builder> ... var1);

        public Builder userCreateDate(Instant var1);

        public Builder userLastModifiedDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder userStatus(String var1);

        public Builder userStatus(UserStatusType var1);

        public Builder mfaOptions(Collection<MFAOptionType> var1);

        public Builder mfaOptions(MFAOptionType ... var1);

        public Builder mfaOptions(Consumer<MFAOptionType.Builder> ... var1);
    }
}

