/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserAttributesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, UpdateUserAttributesRequest> {
    private final List<AttributeType> userAttributes;
    private final String accessToken;

    private UpdateUserAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.userAttributes = builder.userAttributes;
        this.accessToken = builder.accessToken;
    }

    public List<AttributeType> userAttributes() {
        return this.userAttributes;
    }

    public String accessToken() {
        return this.accessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAttributesRequest)) {
            return false;
        }
        UpdateUserAttributesRequest other = (UpdateUserAttributesRequest)((Object)obj);
        return Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.accessToken(), other.accessToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUserAttributesRequest").add("UserAttributes", this.userAttributes()).add("AccessToken", (Object)this.accessToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private String accessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserAttributesRequest model) {
            super(model);
            this.userAttributes(model.userAttributes);
            this.accessToken(model.accessToken);
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            return this.userAttributes != null ? (Collection)this.userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserAttributesRequest build() {
            return new UpdateUserAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, UpdateUserAttributesRequest> {
        public Builder userAttributes(Collection<AttributeType> var1);

        public Builder userAttributes(AttributeType ... var1);

        public Builder userAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder accessToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

