/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.StringAttributeConstraintsTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringAttributeConstraintsType
implements StructuredPojo,
ToCopyableBuilder<Builder, StringAttributeConstraintsType> {
    private final String minLength;
    private final String maxLength;

    private StringAttributeConstraintsType(BuilderImpl builder) {
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
    }

    public String minLength() {
        return this.minLength;
    }

    public String maxLength() {
        return this.maxLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringAttributeConstraintsType)) {
            return false;
        }
        StringAttributeConstraintsType other = (StringAttributeConstraintsType)obj;
        return Objects.equals(this.minLength(), other.minLength()) && Objects.equals(this.maxLength(), other.maxLength());
    }

    public String toString() {
        return ToString.builder((String)"StringAttributeConstraintsType").add("MinLength", (Object)this.minLength()).add("MaxLength", (Object)this.maxLength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinLength": {
                return Optional.ofNullable(clazz.cast(this.minLength()));
            }
            case "MaxLength": {
                return Optional.ofNullable(clazz.cast(this.maxLength()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StringAttributeConstraintsTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String minLength;
        private String maxLength;

        private BuilderImpl() {
        }

        private BuilderImpl(StringAttributeConstraintsType model) {
            this.minLength(model.minLength);
            this.maxLength(model.maxLength);
        }

        public final String getMinLength() {
            return this.minLength;
        }

        @Override
        public final Builder minLength(String minLength) {
            this.minLength = minLength;
            return this;
        }

        public final void setMinLength(String minLength) {
            this.minLength = minLength;
        }

        public final String getMaxLength() {
            return this.maxLength;
        }

        @Override
        public final Builder maxLength(String maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final void setMaxLength(String maxLength) {
            this.maxLength = maxLength;
        }

        public StringAttributeConstraintsType build() {
            return new StringAttributeConstraintsType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StringAttributeConstraintsType> {
        public Builder minLength(String var1);

        public Builder maxLength(String var1);
    }
}

