/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ProviderUserIdentifierTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderUserIdentifierType
implements StructuredPojo,
ToCopyableBuilder<Builder, ProviderUserIdentifierType> {
    private final String providerName;
    private final String providerAttributeName;
    private final String providerAttributeValue;

    private ProviderUserIdentifierType(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.providerAttributeName = builder.providerAttributeName;
        this.providerAttributeValue = builder.providerAttributeValue;
    }

    public String providerName() {
        return this.providerName;
    }

    public String providerAttributeName() {
        return this.providerAttributeName;
    }

    public String providerAttributeValue() {
        return this.providerAttributeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAttributeValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderUserIdentifierType)) {
            return false;
        }
        ProviderUserIdentifierType other = (ProviderUserIdentifierType)obj;
        return Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerAttributeName(), other.providerAttributeName()) && Objects.equals(this.providerAttributeValue(), other.providerAttributeValue());
    }

    public String toString() {
        return ToString.builder((String)"ProviderUserIdentifierType").add("ProviderName", (Object)this.providerName()).add("ProviderAttributeName", (Object)this.providerAttributeName()).add("ProviderAttributeValue", (Object)this.providerAttributeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "ProviderAttributeName": {
                return Optional.ofNullable(clazz.cast(this.providerAttributeName()));
            }
            case "ProviderAttributeValue": {
                return Optional.ofNullable(clazz.cast(this.providerAttributeValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProviderUserIdentifierTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerName;
        private String providerAttributeName;
        private String providerAttributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderUserIdentifierType model) {
            this.providerName(model.providerName);
            this.providerAttributeName(model.providerAttributeName);
            this.providerAttributeValue(model.providerAttributeValue);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getProviderAttributeName() {
            return this.providerAttributeName;
        }

        @Override
        public final Builder providerAttributeName(String providerAttributeName) {
            this.providerAttributeName = providerAttributeName;
            return this;
        }

        public final void setProviderAttributeName(String providerAttributeName) {
            this.providerAttributeName = providerAttributeName;
        }

        public final String getProviderAttributeValue() {
            return this.providerAttributeValue;
        }

        @Override
        public final Builder providerAttributeValue(String providerAttributeValue) {
            this.providerAttributeValue = providerAttributeValue;
            return this;
        }

        public final void setProviderAttributeValue(String providerAttributeValue) {
            this.providerAttributeValue = providerAttributeValue;
        }

        public ProviderUserIdentifierType build() {
            return new ProviderUserIdentifierType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProviderUserIdentifierType> {
        public Builder providerName(String var1);

        public Builder providerAttributeName(String var1);

        public Builder providerAttributeValue(String var1);
    }
}

