/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeMappingTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderTypeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdpIdentifiersListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDetailsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.IdentityProviderTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityProviderType
implements StructuredPojo,
ToCopyableBuilder<Builder, IdentityProviderType> {
    private final String userPoolId;
    private final String providerName;
    private final String providerType;
    private final Map<String, String> providerDetails;
    private final Map<String, String> attributeMapping;
    private final List<String> idpIdentifiers;
    private final Instant lastModifiedDate;
    private final Instant creationDate;

    private IdentityProviderType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.providerName = builder.providerName;
        this.providerType = builder.providerType;
        this.providerDetails = builder.providerDetails;
        this.attributeMapping = builder.attributeMapping;
        this.idpIdentifiers = builder.idpIdentifiers;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String providerName() {
        return this.providerName;
    }

    public IdentityProviderTypeType providerType() {
        return IdentityProviderTypeType.fromValue(this.providerType);
    }

    public String providerTypeAsString() {
        return this.providerType;
    }

    public Map<String, String> providerDetails() {
        return this.providerDetails;
    }

    public Map<String, String> attributeMapping() {
        return this.attributeMapping;
    }

    public List<String> idpIdentifiers() {
        return this.idpIdentifiers;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.idpIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderType)) {
            return false;
        }
        IdentityProviderType other = (IdentityProviderType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.providerDetails(), other.providerDetails()) && Objects.equals(this.attributeMapping(), other.attributeMapping()) && Objects.equals(this.idpIdentifiers(), other.idpIdentifiers()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"IdentityProviderType").add("UserPoolId", (Object)this.userPoolId()).add("ProviderName", (Object)this.providerName()).add("ProviderType", (Object)this.providerTypeAsString()).add("ProviderDetails", this.providerDetails()).add("AttributeMapping", this.attributeMapping()).add("IdpIdentifiers", this.idpIdentifiers()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "ProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.providerDetails()));
            }
            case "AttributeMapping": {
                return Optional.ofNullable(clazz.cast(this.attributeMapping()));
            }
            case "IdpIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.idpIdentifiers()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityProviderTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String providerName;
        private String providerType;
        private Map<String, String> providerDetails = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> attributeMapping = DefaultSdkAutoConstructMap.getInstance();
        private List<String> idpIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private Instant lastModifiedDate;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderType model) {
            this.userPoolId(model.userPoolId);
            this.providerName(model.providerName);
            this.providerType(model.providerType);
            this.providerDetails(model.providerDetails);
            this.attributeMapping(model.attributeMapping);
            this.idpIdentifiers(model.idpIdentifiers);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(IdentityProviderTypeType providerType) {
            this.providerType(providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final Map<String, String> getProviderDetails() {
            return this.providerDetails;
        }

        @Override
        public final Builder providerDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
            return this;
        }

        public final void setProviderDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
        }

        public final Map<String, String> getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        public final Builder attributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
            return this;
        }

        public final void setAttributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
        }

        public final Collection<String> getIdpIdentifiers() {
            return this.idpIdentifiers;
        }

        @Override
        public final Builder idpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idpIdentifiers(String ... idpIdentifiers) {
            this.idpIdentifiers(Arrays.asList(idpIdentifiers));
            return this;
        }

        public final void setIdpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public IdentityProviderType build() {
            return new IdentityProviderType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityProviderType> {
        public Builder userPoolId(String var1);

        public Builder providerName(String var1);

        public Builder providerType(String var1);

        public Builder providerType(IdentityProviderTypeType var1);

        public Builder providerDetails(Map<String, String> var1);

        public Builder attributeMapping(Map<String, String> var1);

        public Builder idpIdentifiers(Collection<String> var1);

        public Builder idpIdentifiers(String ... var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);
    }
}

