/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, GetUserResponse> {
    private final String username;
    private final List<AttributeType> userAttributes;
    private final List<MFAOptionType> mfaOptions;

    private GetUserResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.mfaOptions = builder.mfaOptions;
    }

    public String username() {
        return this.username;
    }

    public List<AttributeType> userAttributes() {
        return this.userAttributes;
    }

    public List<MFAOptionType> mfaOptions() {
        return this.mfaOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResponse)) {
            return false;
        }
        GetUserResponse other = (GetUserResponse)((Object)obj);
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.userAttributes(), other.userAttributes()) && Objects.equals(this.mfaOptions(), other.mfaOptions());
    }

    public String toString() {
        return ToString.builder((String)"GetUserResponse").add("Username", (Object)this.username()).add("UserAttributes", this.userAttributes()).add("MFAOptions", this.mfaOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "MFAOptions": {
                return Optional.ofNullable(clazz.cast(this.mfaOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String username;
        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserResponse model) {
            super(model);
            this.username(model.username);
            this.userAttributes(model.userAttributes);
            this.mfaOptions(model.mfaOptions);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            return this.userAttributes != null ? (Collection)this.userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final Collection<MFAOptionType.Builder> getMFAOptions() {
            return this.mfaOptions != null ? (Collection)this.mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType ... mfaOptions) {
            this.mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder> ... mfaOptions) {
            this.mfaOptions(Stream.of(mfaOptions).map(c -> (MFAOptionType)((MFAOptionType.Builder)MFAOptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMFAOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        @Override
        public GetUserResponse build() {
            return new GetUserResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, GetUserResponse> {
        public Builder username(String var1);

        public Builder userAttributes(Collection<AttributeType> var1);

        public Builder userAttributes(AttributeType ... var1);

        public Builder userAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder mfaOptions(Collection<MFAOptionType> var1);

        public Builder mfaOptions(MFAOptionType ... var1);

        public Builder mfaOptions(Consumer<MFAOptionType.Builder> ... var1);
    }
}

