/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListOfStringTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCsvHeaderResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, GetCsvHeaderResponse> {
    private final String userPoolId;
    private final List<String> csvHeader;

    private GetCsvHeaderResponse(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.csvHeader = builder.csvHeader;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public List<String> csvHeader() {
        return this.csvHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvHeader());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCsvHeaderResponse)) {
            return false;
        }
        GetCsvHeaderResponse other = (GetCsvHeaderResponse)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.csvHeader(), other.csvHeader());
    }

    public String toString() {
        return ToString.builder((String)"GetCsvHeaderResponse").add("UserPoolId", (Object)this.userPoolId()).add("CSVHeader", this.csvHeader()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "CSVHeader": {
                return Optional.ofNullable(clazz.cast(this.csvHeader()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String userPoolId;
        private List<String> csvHeader = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCsvHeaderResponse model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.csvHeader(model.csvHeader);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final Collection<String> getCSVHeader() {
            return this.csvHeader;
        }

        @Override
        public final Builder csvHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder csvHeader(String ... csvHeader) {
            this.csvHeader(Arrays.asList(csvHeader));
            return this;
        }

        public final void setCSVHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
        }

        @Override
        public GetCsvHeaderResponse build() {
            return new GetCsvHeaderResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    CopyableBuilder<Builder, GetCsvHeaderResponse> {
        public Builder userPoolId(String var1);

        public Builder csvHeader(Collection<String> var1);

        public Builder csvHeader(String ... var1);
    }
}

