/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CallbackURLsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientPermissionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExplicitAuthFlowsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ExplicitAuthFlowsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LogoutURLsListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.OAuthFlowsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ScopeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SupportedIdentityProvidersListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserPoolClientRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, CreateUserPoolClientRequest> {
    private final String userPoolId;
    private final String clientName;
    private final Boolean generateSecret;
    private final Integer refreshTokenValidity;
    private final List<String> readAttributes;
    private final List<String> writeAttributes;
    private final List<String> explicitAuthFlows;
    private final List<String> supportedIdentityProviders;
    private final List<String> callbackURLs;
    private final List<String> logoutURLs;
    private final String defaultRedirectURI;
    private final List<String> allowedOAuthFlows;
    private final List<String> allowedOAuthScopes;
    private final Boolean allowedOAuthFlowsUserPoolClient;

    private CreateUserPoolClientRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientName = builder.clientName;
        this.generateSecret = builder.generateSecret;
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.readAttributes = builder.readAttributes;
        this.writeAttributes = builder.writeAttributes;
        this.explicitAuthFlows = builder.explicitAuthFlows;
        this.supportedIdentityProviders = builder.supportedIdentityProviders;
        this.callbackURLs = builder.callbackURLs;
        this.logoutURLs = builder.logoutURLs;
        this.defaultRedirectURI = builder.defaultRedirectURI;
        this.allowedOAuthFlows = builder.allowedOAuthFlows;
        this.allowedOAuthScopes = builder.allowedOAuthScopes;
        this.allowedOAuthFlowsUserPoolClient = builder.allowedOAuthFlowsUserPoolClient;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String clientName() {
        return this.clientName;
    }

    public Boolean generateSecret() {
        return this.generateSecret;
    }

    public Integer refreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public List<String> readAttributes() {
        return this.readAttributes;
    }

    public List<String> writeAttributes() {
        return this.writeAttributes;
    }

    public List<ExplicitAuthFlowsType> explicitAuthFlows() {
        return TypeConverter.convert(this.explicitAuthFlows, ExplicitAuthFlowsType::fromValue);
    }

    public List<String> explicitAuthFlowsAsStrings() {
        return this.explicitAuthFlows;
    }

    public List<String> supportedIdentityProviders() {
        return this.supportedIdentityProviders;
    }

    public List<String> callbackURLs() {
        return this.callbackURLs;
    }

    public List<String> logoutURLs() {
        return this.logoutURLs;
    }

    public String defaultRedirectURI() {
        return this.defaultRedirectURI;
    }

    public List<OAuthFlowType> allowedOAuthFlows() {
        return TypeConverter.convert(this.allowedOAuthFlows, OAuthFlowType::fromValue);
    }

    public List<String> allowedOAuthFlowsAsStrings() {
        return this.allowedOAuthFlows;
    }

    public List<String> allowedOAuthScopes() {
        return this.allowedOAuthScopes;
    }

    public Boolean allowedOAuthFlowsUserPoolClient() {
        return this.allowedOAuthFlowsUserPoolClient;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientName());
        hashCode = 31 * hashCode + Objects.hashCode(this.generateSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshTokenValidity());
        hashCode = 31 * hashCode + Objects.hashCode(this.readAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.explicitAuthFlowsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedIdentityProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackURLs());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoutURLs());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRedirectURI());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOAuthFlowsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOAuthScopes());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOAuthFlowsUserPoolClient());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserPoolClientRequest)) {
            return false;
        }
        CreateUserPoolClientRequest other = (CreateUserPoolClientRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientName(), other.clientName()) && Objects.equals(this.generateSecret(), other.generateSecret()) && Objects.equals(this.refreshTokenValidity(), other.refreshTokenValidity()) && Objects.equals(this.readAttributes(), other.readAttributes()) && Objects.equals(this.writeAttributes(), other.writeAttributes()) && Objects.equals(this.explicitAuthFlowsAsStrings(), other.explicitAuthFlowsAsStrings()) && Objects.equals(this.supportedIdentityProviders(), other.supportedIdentityProviders()) && Objects.equals(this.callbackURLs(), other.callbackURLs()) && Objects.equals(this.logoutURLs(), other.logoutURLs()) && Objects.equals(this.defaultRedirectURI(), other.defaultRedirectURI()) && Objects.equals(this.allowedOAuthFlowsAsStrings(), other.allowedOAuthFlowsAsStrings()) && Objects.equals(this.allowedOAuthScopes(), other.allowedOAuthScopes()) && Objects.equals(this.allowedOAuthFlowsUserPoolClient(), other.allowedOAuthFlowsUserPoolClient());
    }

    public String toString() {
        return ToString.builder((String)"CreateUserPoolClientRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientName", (Object)this.clientName()).add("GenerateSecret", (Object)this.generateSecret()).add("RefreshTokenValidity", (Object)this.refreshTokenValidity()).add("ReadAttributes", this.readAttributes()).add("WriteAttributes", this.writeAttributes()).add("ExplicitAuthFlows", this.explicitAuthFlowsAsStrings()).add("SupportedIdentityProviders", this.supportedIdentityProviders()).add("CallbackURLs", this.callbackURLs()).add("LogoutURLs", this.logoutURLs()).add("DefaultRedirectURI", (Object)this.defaultRedirectURI()).add("AllowedOAuthFlows", this.allowedOAuthFlowsAsStrings()).add("AllowedOAuthScopes", this.allowedOAuthScopes()).add("AllowedOAuthFlowsUserPoolClient", (Object)this.allowedOAuthFlowsUserPoolClient()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientName": {
                return Optional.ofNullable(clazz.cast(this.clientName()));
            }
            case "GenerateSecret": {
                return Optional.ofNullable(clazz.cast(this.generateSecret()));
            }
            case "RefreshTokenValidity": {
                return Optional.ofNullable(clazz.cast(this.refreshTokenValidity()));
            }
            case "ReadAttributes": {
                return Optional.ofNullable(clazz.cast(this.readAttributes()));
            }
            case "WriteAttributes": {
                return Optional.ofNullable(clazz.cast(this.writeAttributes()));
            }
            case "ExplicitAuthFlows": {
                return Optional.ofNullable(clazz.cast(this.explicitAuthFlowsAsStrings()));
            }
            case "SupportedIdentityProviders": {
                return Optional.ofNullable(clazz.cast(this.supportedIdentityProviders()));
            }
            case "CallbackURLs": {
                return Optional.ofNullable(clazz.cast(this.callbackURLs()));
            }
            case "LogoutURLs": {
                return Optional.ofNullable(clazz.cast(this.logoutURLs()));
            }
            case "DefaultRedirectURI": {
                return Optional.ofNullable(clazz.cast(this.defaultRedirectURI()));
            }
            case "AllowedOAuthFlows": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthFlowsAsStrings()));
            }
            case "AllowedOAuthScopes": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthScopes()));
            }
            case "AllowedOAuthFlowsUserPoolClient": {
                return Optional.ofNullable(clazz.cast(this.allowedOAuthFlowsUserPoolClient()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientName;
        private Boolean generateSecret;
        private Integer refreshTokenValidity;
        private List<String> readAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> writeAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> explicitAuthFlows = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedIdentityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> callbackURLs = DefaultSdkAutoConstructList.getInstance();
        private List<String> logoutURLs = DefaultSdkAutoConstructList.getInstance();
        private String defaultRedirectURI;
        private List<String> allowedOAuthFlows = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedOAuthScopes = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowedOAuthFlowsUserPoolClient;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserPoolClientRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientName(model.clientName);
            this.generateSecret(model.generateSecret);
            this.refreshTokenValidity(model.refreshTokenValidity);
            this.readAttributes(model.readAttributes);
            this.writeAttributes(model.writeAttributes);
            this.explicitAuthFlowsWithStrings(model.explicitAuthFlows);
            this.supportedIdentityProviders(model.supportedIdentityProviders);
            this.callbackURLs(model.callbackURLs);
            this.logoutURLs(model.logoutURLs);
            this.defaultRedirectURI(model.defaultRedirectURI);
            this.allowedOAuthFlowsWithStrings(model.allowedOAuthFlows);
            this.allowedOAuthScopes(model.allowedOAuthScopes);
            this.allowedOAuthFlowsUserPoolClient(model.allowedOAuthFlowsUserPoolClient);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientName() {
            return this.clientName;
        }

        @Override
        public final Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public final void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public final Boolean getGenerateSecret() {
            return this.generateSecret;
        }

        @Override
        public final Builder generateSecret(Boolean generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        public final void setGenerateSecret(Boolean generateSecret) {
            this.generateSecret = generateSecret;
        }

        public final Integer getRefreshTokenValidity() {
            return this.refreshTokenValidity;
        }

        @Override
        public final Builder refreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final void setRefreshTokenValidity(Integer refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        public final Collection<String> getReadAttributes() {
            return this.readAttributes;
        }

        @Override
        public final Builder readAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readAttributes(String ... readAttributes) {
            this.readAttributes(Arrays.asList(readAttributes));
            return this;
        }

        public final void setReadAttributes(Collection<String> readAttributes) {
            this.readAttributes = ClientPermissionListTypeCopier.copy(readAttributes);
        }

        public final Collection<String> getWriteAttributes() {
            return this.writeAttributes;
        }

        @Override
        public final Builder writeAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder writeAttributes(String ... writeAttributes) {
            this.writeAttributes(Arrays.asList(writeAttributes));
            return this;
        }

        public final void setWriteAttributes(Collection<String> writeAttributes) {
            this.writeAttributes = ClientPermissionListTypeCopier.copy(writeAttributes);
        }

        public final Collection<String> getExplicitAuthFlows() {
            return this.explicitAuthFlows;
        }

        @Override
        public final Builder explicitAuthFlowsWithStrings(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlowsWithStrings(String ... explicitAuthFlows) {
            this.explicitAuthFlowsWithStrings(Arrays.asList(explicitAuthFlows));
            return this;
        }

        @Override
        public final Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copyEnumToString(explicitAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explicitAuthFlows(ExplicitAuthFlowsType ... explicitAuthFlows) {
            this.explicitAuthFlows(Arrays.asList(explicitAuthFlows));
            return this;
        }

        public final void setExplicitAuthFlows(Collection<String> explicitAuthFlows) {
            this.explicitAuthFlows = ExplicitAuthFlowsListTypeCopier.copy(explicitAuthFlows);
        }

        public final Collection<String> getSupportedIdentityProviders() {
            return this.supportedIdentityProviders;
        }

        @Override
        public final Builder supportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedIdentityProviders(String ... supportedIdentityProviders) {
            this.supportedIdentityProviders(Arrays.asList(supportedIdentityProviders));
            return this;
        }

        public final void setSupportedIdentityProviders(Collection<String> supportedIdentityProviders) {
            this.supportedIdentityProviders = SupportedIdentityProvidersListTypeCopier.copy(supportedIdentityProviders);
        }

        public final Collection<String> getCallbackURLs() {
            return this.callbackURLs;
        }

        @Override
        public final Builder callbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callbackURLs(String ... callbackURLs) {
            this.callbackURLs(Arrays.asList(callbackURLs));
            return this;
        }

        public final void setCallbackURLs(Collection<String> callbackURLs) {
            this.callbackURLs = CallbackURLsListTypeCopier.copy(callbackURLs);
        }

        public final Collection<String> getLogoutURLs() {
            return this.logoutURLs;
        }

        @Override
        public final Builder logoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logoutURLs(String ... logoutURLs) {
            this.logoutURLs(Arrays.asList(logoutURLs));
            return this;
        }

        public final void setLogoutURLs(Collection<String> logoutURLs) {
            this.logoutURLs = LogoutURLsListTypeCopier.copy(logoutURLs);
        }

        public final String getDefaultRedirectURI() {
            return this.defaultRedirectURI;
        }

        @Override
        public final Builder defaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
            return this;
        }

        public final void setDefaultRedirectURI(String defaultRedirectURI) {
            this.defaultRedirectURI = defaultRedirectURI;
        }

        public final Collection<String> getAllowedOAuthFlows() {
            return this.allowedOAuthFlows;
        }

        @Override
        public final Builder allowedOAuthFlowsWithStrings(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlowsWithStrings(String ... allowedOAuthFlows) {
            this.allowedOAuthFlowsWithStrings(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        @Override
        public final Builder allowedOAuthFlows(Collection<OAuthFlowType> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copyEnumToString(allowedOAuthFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthFlows(OAuthFlowType ... allowedOAuthFlows) {
            this.allowedOAuthFlows(Arrays.asList(allowedOAuthFlows));
            return this;
        }

        public final void setAllowedOAuthFlows(Collection<String> allowedOAuthFlows) {
            this.allowedOAuthFlows = OAuthFlowsTypeCopier.copy(allowedOAuthFlows);
        }

        public final Collection<String> getAllowedOAuthScopes() {
            return this.allowedOAuthScopes;
        }

        @Override
        public final Builder allowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOAuthScopes(String ... allowedOAuthScopes) {
            this.allowedOAuthScopes(Arrays.asList(allowedOAuthScopes));
            return this;
        }

        public final void setAllowedOAuthScopes(Collection<String> allowedOAuthScopes) {
            this.allowedOAuthScopes = ScopeListTypeCopier.copy(allowedOAuthScopes);
        }

        public final Boolean getAllowedOAuthFlowsUserPoolClient() {
            return this.allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public final Builder allowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        public final void setAllowedOAuthFlowsUserPoolClient(Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserPoolClientRequest build() {
            return new CreateUserPoolClientRequest(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    CopyableBuilder<Builder, CreateUserPoolClientRequest> {
        public Builder userPoolId(String var1);

        public Builder clientName(String var1);

        public Builder generateSecret(Boolean var1);

        public Builder refreshTokenValidity(Integer var1);

        public Builder readAttributes(Collection<String> var1);

        public Builder readAttributes(String ... var1);

        public Builder writeAttributes(Collection<String> var1);

        public Builder writeAttributes(String ... var1);

        public Builder explicitAuthFlowsWithStrings(Collection<String> var1);

        public Builder explicitAuthFlowsWithStrings(String ... var1);

        public Builder explicitAuthFlows(Collection<ExplicitAuthFlowsType> var1);

        public Builder explicitAuthFlows(ExplicitAuthFlowsType ... var1);

        public Builder supportedIdentityProviders(Collection<String> var1);

        public Builder supportedIdentityProviders(String ... var1);

        public Builder callbackURLs(Collection<String> var1);

        public Builder callbackURLs(String ... var1);

        public Builder logoutURLs(Collection<String> var1);

        public Builder logoutURLs(String ... var1);

        public Builder defaultRedirectURI(String var1);

        public Builder allowedOAuthFlowsWithStrings(Collection<String> var1);

        public Builder allowedOAuthFlowsWithStrings(String ... var1);

        public Builder allowedOAuthFlows(Collection<OAuthFlowType> var1);

        public Builder allowedOAuthFlows(OAuthFlowType ... var1);

        public Builder allowedOAuthScopes(Collection<String> var1);

        public Builder allowedOAuthScopes(String ... var1);

        public Builder allowedOAuthFlowsUserPoolClient(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

