/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.NewDeviceMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AuthenticationResultTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationResultType
implements StructuredPojo,
ToCopyableBuilder<Builder, AuthenticationResultType> {
    private final String accessToken;
    private final Integer expiresIn;
    private final String tokenType;
    private final String refreshToken;
    private final String idToken;
    private final NewDeviceMetadataType newDeviceMetadata;

    private AuthenticationResultType(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.expiresIn = builder.expiresIn;
        this.tokenType = builder.tokenType;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
        this.newDeviceMetadata = builder.newDeviceMetadata;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public Integer expiresIn() {
        return this.expiresIn;
    }

    public String tokenType() {
        return this.tokenType;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public String idToken() {
        return this.idToken;
    }

    public NewDeviceMetadataType newDeviceMetadata() {
        return this.newDeviceMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.idToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDeviceMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationResultType)) {
            return false;
        }
        AuthenticationResultType other = (AuthenticationResultType)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.expiresIn(), other.expiresIn()) && Objects.equals(this.tokenType(), other.tokenType()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.idToken(), other.idToken()) && Objects.equals(this.newDeviceMetadata(), other.newDeviceMetadata());
    }

    public String toString() {
        return ToString.builder((String)"AuthenticationResultType").add("AccessToken", (Object)this.accessToken()).add("ExpiresIn", (Object)this.expiresIn()).add("TokenType", (Object)this.tokenType()).add("RefreshToken", (Object)this.refreshToken()).add("IdToken", (Object)this.idToken()).add("NewDeviceMetadata", (Object)this.newDeviceMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "ExpiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
            case "TokenType": {
                return Optional.ofNullable(clazz.cast(this.tokenType()));
            }
            case "RefreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "IdToken": {
                return Optional.ofNullable(clazz.cast(this.idToken()));
            }
            case "NewDeviceMetadata": {
                return Optional.ofNullable(clazz.cast(this.newDeviceMetadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationResultTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private Integer expiresIn;
        private String tokenType;
        private String refreshToken;
        private String idToken;
        private NewDeviceMetadataType newDeviceMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationResultType model) {
            this.accessToken(model.accessToken);
            this.expiresIn(model.expiresIn);
            this.tokenType(model.tokenType);
            this.refreshToken(model.refreshToken);
            this.idToken(model.idToken);
            this.newDeviceMetadata(model.newDeviceMetadata);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final Integer getExpiresIn() {
            return this.expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        public final String getTokenType() {
            return this.tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public final String getIdToken() {
            return this.idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        public final NewDeviceMetadataType.Builder getNewDeviceMetadata() {
            return this.newDeviceMetadata != null ? this.newDeviceMetadata.toBuilder() : null;
        }

        @Override
        public final Builder newDeviceMetadata(NewDeviceMetadataType newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata;
            return this;
        }

        public final void setNewDeviceMetadata(NewDeviceMetadataType.BuilderImpl newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata != null ? newDeviceMetadata.build() : null;
        }

        public AuthenticationResultType build() {
            return new AuthenticationResultType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuthenticationResultType> {
        public Builder accessToken(String var1);

        public Builder expiresIn(Integer var1);

        public Builder tokenType(String var1);

        public Builder refreshToken(String var1);

        public Builder idToken(String var1);

        public Builder newDeviceMetadata(NewDeviceMetadataType var1);

        default public Builder newDeviceMetadata(Consumer<NewDeviceMetadataType.Builder> newDeviceMetadata) {
            return this.newDeviceMetadata((NewDeviceMetadataType)((NewDeviceMetadataType.Builder)NewDeviceMetadataType.builder().applyMutation(newDeviceMetadata)).build());
        }
    }
}

