/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UserType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UserTypeMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();

    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();

    private static final MarshallingInfo<Instant> USERCREATEDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserCreateDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> USERLASTMODIFIEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserLastModifiedDate").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();

    private static final MarshallingInfo<String> USERSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserStatus").isBinary(false).build();

    private static final MarshallingInfo<List> MFAOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MFAOptions").isBinary(false).build();

    private static final UserTypeMarshaller INSTANCE = new UserTypeMarshaller();

    private UserTypeMarshaller() {
    }

    public static UserTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UserType userType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(userType, "userType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(userType.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(userType.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userType.userCreateDate(), USERCREATEDATE_BINDING);
            protocolMarshaller.marshall(userType.userLastModifiedDate(), USERLASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall(userType.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(userType.userStatusAsString(), USERSTATUS_BINDING);
            protocolMarshaller.marshall(userType.mfaOptions(), MFAOPTIONS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
