/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UserPoolClientType JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UserPoolClientTypeUnmarshaller implements Unmarshaller<UserPoolClientType, JsonUnmarshallerContext> {

    public UserPoolClientType unmarshall(JsonUnmarshallerContext context) throws Exception {
        UserPoolClientType.Builder userPoolClientTypeBuilder = UserPoolClientType.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("UserPoolId", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.userPoolId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ClientName", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.clientName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ClientId", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.clientId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ClientSecret", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.clientSecret(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.lastModifiedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.creationDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("RefreshTokenValidity", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.refreshTokenValidity(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ReadAttributes", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.readAttributes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("WriteAttributes", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.writeAttributes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("ExplicitAuthFlows", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.explicitAuthFlowsWithStrings(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SupportedIdentityProviders", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.supportedIdentityProviders(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CallbackURLs", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.callbackURLs(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("LogoutURLs", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.logoutURLs(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("DefaultRedirectURI", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.defaultRedirectURI(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("AllowedOAuthFlows", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.allowedOAuthFlowsWithStrings(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("AllowedOAuthScopes", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.allowedOAuthScopes(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("AllowedOAuthFlowsUserPoolClient", targetDepth)) {
                    context.nextToken();
                    userPoolClientTypeBuilder.allowedOAuthFlowsUserPoolClient(context.getUnmarshaller(Boolean.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return userPoolClientTypeBuilder.build();
    }

    private static final UserPoolClientTypeUnmarshaller INSTANCE = new UserPoolClientTypeUnmarshaller();

    public static UserPoolClientTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
