/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UserPoolClientType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UserPoolClientTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientName").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTSECRET_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientSecret").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();

    private static final MarshallingInfo<Integer> REFRESHTOKENVALIDITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshTokenValidity").isBinary(false).build();

    private static final MarshallingInfo<List> READATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> WRITEATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriteAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> EXPLICITAUTHFLOWS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExplicitAuthFlows").isBinary(false).build();

    private static final MarshallingInfo<List> SUPPORTEDIDENTITYPROVIDERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedIdentityProviders").isBinary(false)
            .build();

    private static final MarshallingInfo<List> CALLBACKURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CallbackURLs").isBinary(false).build();

    private static final MarshallingInfo<List> LOGOUTURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogoutURLs").isBinary(false).build();

    private static final MarshallingInfo<String> DEFAULTREDIRECTURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRedirectURI").isBinary(false).build();

    private static final MarshallingInfo<List> ALLOWEDOAUTHFLOWS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthFlows").isBinary(false).build();

    private static final MarshallingInfo<List> ALLOWEDOAUTHSCOPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthScopes").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AllowedOAuthFlowsUserPoolClient").isBinary(false).build();

    private static final UserPoolClientTypeMarshaller INSTANCE = new UserPoolClientTypeMarshaller();

    private UserPoolClientTypeMarshaller() {
    }

    public static UserPoolClientTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UserPoolClientType userPoolClientType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(userPoolClientType, "userPoolClientType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(userPoolClientType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(userPoolClientType.clientName(), CLIENTNAME_BINDING);
            protocolMarshaller.marshall(userPoolClientType.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(userPoolClientType.clientSecret(), CLIENTSECRET_BINDING);
            protocolMarshaller.marshall(userPoolClientType.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall(userPoolClientType.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(userPoolClientType.refreshTokenValidity(), REFRESHTOKENVALIDITY_BINDING);
            protocolMarshaller.marshall(userPoolClientType.readAttributes(), READATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolClientType.writeAttributes(), WRITEATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolClientType.explicitAuthFlowsAsStrings(), EXPLICITAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.supportedIdentityProviders(), SUPPORTEDIDENTITYPROVIDERS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.callbackURLs(), CALLBACKURLS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.logoutURLs(), LOGOUTURLS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.defaultRedirectURI(), DEFAULTREDIRECTURI_BINDING);
            protocolMarshaller.marshall(userPoolClientType.allowedOAuthFlowsAsStrings(), ALLOWEDOAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(userPoolClientType.allowedOAuthScopes(), ALLOWEDOAUTHSCOPES_BINDING);
            protocolMarshaller.marshall(userPoolClientType.allowedOAuthFlowsUserPoolClient(),
                    ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
