/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UserImportJobType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UserImportJobTypeMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();

    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();

    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> PRESIGNEDURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreSignedUrl").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> COMPLETIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDate").isBinary(false).build();

    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<String> CLOUDWATCHLOGSROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLogsRoleArn").isBinary(false).build();

    private static final MarshallingInfo<Long> IMPORTEDUSERS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedUsers").isBinary(false).build();

    private static final MarshallingInfo<Long> SKIPPEDUSERS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkippedUsers").isBinary(false).build();

    private static final MarshallingInfo<Long> FAILEDUSERS_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailedUsers").isBinary(false).build();

    private static final MarshallingInfo<String> COMPLETIONMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionMessage").isBinary(false).build();

    private static final UserImportJobTypeMarshaller INSTANCE = new UserImportJobTypeMarshaller();

    private UserImportJobTypeMarshaller() {
    }

    public static UserImportJobTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UserImportJobType userImportJobType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(userImportJobType, "userImportJobType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(userImportJobType.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall(userImportJobType.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall(userImportJobType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(userImportJobType.preSignedUrl(), PRESIGNEDURL_BINDING);
            protocolMarshaller.marshall(userImportJobType.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(userImportJobType.startDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall(userImportJobType.completionDate(), COMPLETIONDATE_BINDING);
            protocolMarshaller.marshall(userImportJobType.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(userImportJobType.cloudWatchLogsRoleArn(), CLOUDWATCHLOGSROLEARN_BINDING);
            protocolMarshaller.marshall(userImportJobType.importedUsers(), IMPORTEDUSERS_BINDING);
            protocolMarshaller.marshall(userImportJobType.skippedUsers(), SKIPPEDUSERS_BINDING);
            protocolMarshaller.marshall(userImportJobType.failedUsers(), FAILEDUSERS_BINDING);
            protocolMarshaller.marshall(userImportJobType.completionMessage(), COMPLETIONMESSAGE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
