/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateUserPoolClientRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateUserPoolClientRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientName").isBinary(false).build();

    private static final MarshallingInfo<Integer> REFRESHTOKENVALIDITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshTokenValidity").isBinary(false).build();

    private static final MarshallingInfo<List> READATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> WRITEATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriteAttributes").isBinary(false).build();

    private static final MarshallingInfo<List> EXPLICITAUTHFLOWS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExplicitAuthFlows").isBinary(false).build();

    private static final MarshallingInfo<List> SUPPORTEDIDENTITYPROVIDERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedIdentityProviders").isBinary(false)
            .build();

    private static final MarshallingInfo<List> CALLBACKURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CallbackURLs").isBinary(false).build();

    private static final MarshallingInfo<List> LOGOUTURLS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogoutURLs").isBinary(false).build();

    private static final MarshallingInfo<String> DEFAULTREDIRECTURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRedirectURI").isBinary(false).build();

    private static final MarshallingInfo<List> ALLOWEDOAUTHFLOWS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthFlows").isBinary(false).build();

    private static final MarshallingInfo<List> ALLOWEDOAUTHSCOPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthScopes").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AllowedOAuthFlowsUserPoolClient").isBinary(false).build();

    private static final UpdateUserPoolClientRequestModelMarshaller INSTANCE = new UpdateUserPoolClientRequestModelMarshaller();

    private UpdateUserPoolClientRequestModelMarshaller() {
    }

    public static UpdateUserPoolClientRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateUserPoolClientRequest updateUserPoolClientRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateUserPoolClientRequest, "updateUserPoolClientRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateUserPoolClientRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.clientName(), CLIENTNAME_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.refreshTokenValidity(), REFRESHTOKENVALIDITY_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.readAttributes(), READATTRIBUTES_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.writeAttributes(), WRITEATTRIBUTES_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.explicitAuthFlowsAsStrings(), EXPLICITAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.supportedIdentityProviders(),
                    SUPPORTEDIDENTITYPROVIDERS_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.callbackURLs(), CALLBACKURLS_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.logoutURLs(), LOGOUTURLS_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.defaultRedirectURI(), DEFAULTREDIRECTURI_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.allowedOAuthFlowsAsStrings(), ALLOWEDOAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.allowedOAuthScopes(), ALLOWEDOAUTHSCOPES_BINDING);
            protocolMarshaller.marshall(updateUserPoolClientRequest.allowedOAuthFlowsUserPoolClient(),
                    ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
