/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateIdentityProviderRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateIdentityProviderRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();

    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderName").isBinary(false).build();

    private static final MarshallingInfo<Map> PROVIDERDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderDetails").isBinary(false).build();

    private static final MarshallingInfo<Map> ATTRIBUTEMAPPING_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeMapping").isBinary(false).build();

    private static final MarshallingInfo<List> IDPIDENTIFIERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdpIdentifiers").isBinary(false).build();

    private static final UpdateIdentityProviderRequestModelMarshaller INSTANCE = new UpdateIdentityProviderRequestModelMarshaller();

    private UpdateIdentityProviderRequestModelMarshaller() {
    }

    public static UpdateIdentityProviderRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateIdentityProviderRequest updateIdentityProviderRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateIdentityProviderRequest, "updateIdentityProviderRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateIdentityProviderRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall(updateIdentityProviderRequest.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall(updateIdentityProviderRequest.providerDetails(), PROVIDERDETAILS_BINDING);
            protocolMarshaller.marshall(updateIdentityProviderRequest.attributeMapping(), ATTRIBUTEMAPPING_BINDING);
            protocolMarshaller.marshall(updateIdentityProviderRequest.idpIdentifiers(), IDPIDENTIFIERS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
