/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SchemaAttributeType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SchemaAttributeTypeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> ATTRIBUTEDATATYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeDataType").isBinary(false).build();

    private static final MarshallingInfo<Boolean> DEVELOPERONLYATTRIBUTE_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeveloperOnlyAttribute").isBinary(false).build();

    private static final MarshallingInfo<Boolean> MUTABLE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mutable").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIRED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Required").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NUMBERATTRIBUTECONSTRAINTS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NumberAttributeConstraints").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> STRINGATTRIBUTECONSTRAINTS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("StringAttributeConstraints").isBinary(false).build();

    private static final SchemaAttributeTypeMarshaller INSTANCE = new SchemaAttributeTypeMarshaller();

    private SchemaAttributeTypeMarshaller() {
    }

    public static SchemaAttributeTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SchemaAttributeType schemaAttributeType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(schemaAttributeType, "schemaAttributeType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(schemaAttributeType.name(), NAME_BINDING);
            protocolMarshaller.marshall(schemaAttributeType.attributeDataTypeAsString(), ATTRIBUTEDATATYPE_BINDING);
            protocolMarshaller.marshall(schemaAttributeType.developerOnlyAttribute(), DEVELOPERONLYATTRIBUTE_BINDING);
            protocolMarshaller.marshall(schemaAttributeType.mutable(), MUTABLE_BINDING);
            protocolMarshaller.marshall(schemaAttributeType.required(), REQUIRED_BINDING);
            protocolMarshaller.marshall(schemaAttributeType.numberAttributeConstraints(), NUMBERATTRIBUTECONSTRAINTS_BINDING);
            protocolMarshaller.marshall(schemaAttributeType.stringAttributeConstraints(), STRINGATTRIBUTECONSTRAINTS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
