/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ListIdentityProvidersResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListIdentityProvidersResponseUnmarshaller implements
        Unmarshaller<ListIdentityProvidersResponse, JsonUnmarshallerContext> {

    public ListIdentityProvidersResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        ListIdentityProvidersResponse.Builder listIdentityProvidersResponseBuilder = ListIdentityProvidersResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return listIdentityProvidersResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Providers", targetDepth)) {
                    context.nextToken();
                    listIdentityProvidersResponseBuilder.providers(new ListUnmarshaller<ProviderDescription>(
                            ProviderDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("NextToken", targetDepth)) {
                    context.nextToken();
                    listIdentityProvidersResponseBuilder.nextToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return listIdentityProvidersResponseBuilder.build();
    }

    private static final ListIdentityProvidersResponseUnmarshaller INSTANCE = new ListIdentityProvidersResponseUnmarshaller();

    public static ListIdentityProvidersResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
