/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceType;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DeviceType} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DeviceTypeMarshaller {
    private static final MarshallingInfo<String> DEVICEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceKey").isBinary(false).build();

    private static final MarshallingInfo<List> DEVICEATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceAttributes").isBinary(false).build();

    private static final MarshallingInfo<Instant> DEVICECREATEDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceCreateDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> DEVICELASTMODIFIEDDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeviceLastModifiedDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> DEVICELASTAUTHENTICATEDDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeviceLastAuthenticatedDate").isBinary(false).build();

    private static final DeviceTypeMarshaller INSTANCE = new DeviceTypeMarshaller();

    private DeviceTypeMarshaller() {
    }

    public static DeviceTypeMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DeviceType deviceType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(deviceType, "deviceType");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(deviceType.deviceKey(), DEVICEKEY_BINDING);
            protocolMarshaller.marshall(deviceType.deviceAttributes(), DEVICEATTRIBUTES_BINDING);
            protocolMarshaller.marshall(deviceType.deviceCreateDate(), DEVICECREATEDATE_BINDING);
            protocolMarshaller.marshall(deviceType.deviceLastModifiedDate(), DEVICELASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall(deviceType.deviceLastAuthenticatedDate(), DEVICELASTAUTHENTICATEDDATE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
