/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ConfirmDeviceRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ConfirmDeviceRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ConfirmDeviceRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").isBinary(false).build();

    private static final MarshallingInfo<String> DEVICEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceKey").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DEVICESECRETVERIFIERCONFIG_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DeviceSecretVerifierConfig").isBinary(false).build();

    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").isBinary(false).build();

    private static final ConfirmDeviceRequestModelMarshaller INSTANCE = new ConfirmDeviceRequestModelMarshaller();

    private ConfirmDeviceRequestModelMarshaller() {
    }

    public static ConfirmDeviceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ConfirmDeviceRequest confirmDeviceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(confirmDeviceRequest, "confirmDeviceRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(confirmDeviceRequest.accessToken(), ACCESSTOKEN_BINDING);
            protocolMarshaller.marshall(confirmDeviceRequest.deviceKey(), DEVICEKEY_BINDING);
            protocolMarshaller.marshall(confirmDeviceRequest.deviceSecretVerifierConfig(), DEVICESECRETVERIFIERCONFIG_BINDING);
            protocolMarshaller.marshall(confirmDeviceRequest.deviceName(), DEVICENAME_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
