/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cognitoidentityprovider.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AdminGetUserResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AdminGetUserResponseUnmarshaller implements Unmarshaller<AdminGetUserResponse, JsonUnmarshallerContext> {

    public AdminGetUserResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        AdminGetUserResponse.Builder adminGetUserResponseBuilder = AdminGetUserResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return adminGetUserResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Username", targetDepth)) {
                    context.nextToken();
                    adminGetUserResponseBuilder.username(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("UserAttributes", targetDepth)) {
                    context.nextToken();
                    adminGetUserResponseBuilder.userAttributes(new ListUnmarshaller<AttributeType>(AttributeTypeUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("UserCreateDate", targetDepth)) {
                    context.nextToken();
                    adminGetUserResponseBuilder.userCreateDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("UserLastModifiedDate", targetDepth)) {
                    context.nextToken();
                    adminGetUserResponseBuilder.userLastModifiedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(
                            context));
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    adminGetUserResponseBuilder.enabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("UserStatus", targetDepth)) {
                    context.nextToken();
                    adminGetUserResponseBuilder.userStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MFAOptions", targetDepth)) {
                    context.nextToken();
                    adminGetUserResponseBuilder.mfaOptions(new ListUnmarshaller<MFAOptionType>(MFAOptionTypeUnmarshaller
                            .getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return adminGetUserResponseBuilder.build();
    }

    private static final AdminGetUserResponseUnmarshaller INSTANCE = new AdminGetUserResponseUnmarshaller();

    public static AdminGetUserResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
