/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the request to verify user attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyUserAttributeRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<VerifyUserAttributeRequest.Builder, VerifyUserAttributeRequest> {
    private final String accessToken;

    private final String attributeName;

    private final String code;

    private VerifyUserAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.attributeName = builder.attributeName;
        this.code = builder.code;
    }

    /**
     * <p>
     * Represents the access token of the request to verify user attributes.
     * </p>
     * 
     * @return Represents the access token of the request to verify user attributes.
     */
    public String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The attribute name in the request to verify user attributes.
     * </p>
     * 
     * @return The attribute name in the request to verify user attributes.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The verification code in the request to verify user attributes.
     * </p>
     * 
     * @return The verification code in the request to verify user attributes.
     */
    public String code() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyUserAttributeRequest)) {
            return false;
        }
        VerifyUserAttributeRequest other = (VerifyUserAttributeRequest) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(code(), other.code());
    }

    @Override
    public String toString() {
        return ToString.builder("VerifyUserAttributeRequest").add("AccessToken", accessToken())
                .add("AttributeName", attributeName()).add("Code", code()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder, CopyableBuilder<Builder, VerifyUserAttributeRequest> {
        /**
         * <p>
         * Represents the access token of the request to verify user attributes.
         * </p>
         * 
         * @param accessToken
         *        Represents the access token of the request to verify user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The attribute name in the request to verify user attributes.
         * </p>
         * 
         * @param attributeName
         *        The attribute name in the request to verify user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The verification code in the request to verify user attributes.
         * </p>
         * 
         * @param code
         *        The verification code in the request to verify user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String accessToken;

        private String attributeName;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyUserAttributeRequest model) {
            super(model);
            accessToken(model.accessToken);
            attributeName(model.attributeName);
            code(model.code);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyUserAttributeRequest build() {
            return new VerifyUserAttributeRequest(this);
        }
    }
}
