/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UserImportJobTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user import job type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserImportJobType implements StructuredPojo, ToCopyableBuilder<UserImportJobType.Builder, UserImportJobType> {
    private final String jobName;

    private final String jobId;

    private final String userPoolId;

    private final String preSignedUrl;

    private final Instant creationDate;

    private final Instant startDate;

    private final Instant completionDate;

    private final String status;

    private final String cloudWatchLogsRoleArn;

    private final Long importedUsers;

    private final Long skippedUsers;

    private final Long failedUsers;

    private final String completionMessage;

    private UserImportJobType(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
        this.userPoolId = builder.userPoolId;
        this.preSignedUrl = builder.preSignedUrl;
        this.creationDate = builder.creationDate;
        this.startDate = builder.startDate;
        this.completionDate = builder.completionDate;
        this.status = builder.status;
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.importedUsers = builder.importedUsers;
        this.skippedUsers = builder.skippedUsers;
        this.failedUsers = builder.failedUsers;
        this.completionMessage = builder.completionMessage;
    }

    /**
     * <p>
     * The job name for the user import job.
     * </p>
     * 
     * @return The job name for the user import job.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job ID for the user import job.
     * </p>
     * 
     * @return The job ID for the user import job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The user pool ID for the user pool that the users are being imported into.
     * </p>
     * 
     * @return The user pool ID for the user pool that the users are being imported into.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The pre-signed URL to be used to upload the <code>.csv</code> file.
     * </p>
     * 
     * @return The pre-signed URL to be used to upload the <code>.csv</code> file.
     */
    public String preSignedUrl() {
        return preSignedUrl;
    }

    /**
     * <p>
     * The date the user import job was created.
     * </p>
     * 
     * @return The date the user import job was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the user import job was started.
     * </p>
     * 
     * @return The date when the user import job was started.
     */
    public Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date when the user import job was completed.
     * </p>
     * 
     * @return The date when the user import job was completed.
     */
    public Instant completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * The status of the user import job. One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Created</code> - The job was created but not started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code> - The job has started, and users are being imported.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Succeeded</code> - The job has completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The job has stopped due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with
     * the job was deleted, and the job cannot be started.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserImportJobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user import job. One of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Created</code> - The job was created but not started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users
     *         yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code> - The job has started, and users are being imported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Succeeded</code> - The job has completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The job has stopped due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data
     *         associated with the job was deleted, and the job cannot be started.
     *         </p>
     *         </li>
     * @see UserImportJobStatusType
     */
    public UserImportJobStatusType status() {
        return UserImportJobStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the user import job. One of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Created</code> - The job was created but not started.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code> - The job has started, and users are being imported.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Succeeded</code> - The job has completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code> - The job has stopped due to an error.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated with
     * the job was deleted, and the job cannot be started.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserImportJobStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user import job. One of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Created</code> - The job was created but not started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users
     *         yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code> - The job has started, and users are being imported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Succeeded</code> - The job has completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code> - The job has stopped due to an error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data
     *         associated with the job was deleted, and the job cannot be started.
     *         </p>
     *         </li>
     * @see UserImportJobStatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The role ARN for the Amazon CloudWatch Logging role for the user import job. For more information, see
     * "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.
     * </p>
     * 
     * @return The role ARN for the Amazon CloudWatch Logging role for the user import job. For more information, see
     *         "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.
     */
    public String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * The number of users that were successfully imported.
     * </p>
     * 
     * @return The number of users that were successfully imported.
     */
    public Long importedUsers() {
        return importedUsers;
    }

    /**
     * <p>
     * The number of users that were skipped.
     * </p>
     * 
     * @return The number of users that were skipped.
     */
    public Long skippedUsers() {
        return skippedUsers;
    }

    /**
     * <p>
     * The number of users that could not be imported.
     * </p>
     * 
     * @return The number of users that could not be imported.
     */
    public Long failedUsers() {
        return failedUsers;
    }

    /**
     * <p>
     * The message returned when the user import job is completed.
     * </p>
     * 
     * @return The message returned when the user import job is completed.
     */
    public String completionMessage() {
        return completionMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(importedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(skippedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(failedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(completionMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserImportJobType)) {
            return false;
        }
        UserImportJobType other = (UserImportJobType) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(preSignedUrl(), other.preSignedUrl())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn())
                && Objects.equals(importedUsers(), other.importedUsers()) && Objects.equals(skippedUsers(), other.skippedUsers())
                && Objects.equals(failedUsers(), other.failedUsers())
                && Objects.equals(completionMessage(), other.completionMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("UserImportJobType").add("JobName", jobName()).add("JobId", jobId())
                .add("UserPoolId", userPoolId()).add("PreSignedUrl", preSignedUrl()).add("CreationDate", creationDate())
                .add("StartDate", startDate()).add("CompletionDate", completionDate()).add("Status", statusAsString())
                .add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn()).add("ImportedUsers", importedUsers())
                .add("SkippedUsers", skippedUsers()).add("FailedUsers", failedUsers())
                .add("CompletionMessage", completionMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "PreSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        case "ImportedUsers":
            return Optional.ofNullable(clazz.cast(importedUsers()));
        case "SkippedUsers":
            return Optional.ofNullable(clazz.cast(skippedUsers()));
        case "FailedUsers":
            return Optional.ofNullable(clazz.cast(failedUsers()));
        case "CompletionMessage":
            return Optional.ofNullable(clazz.cast(completionMessage()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserImportJobTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, UserImportJobType> {
        /**
         * <p>
         * The job name for the user import job.
         * </p>
         * 
         * @param jobName
         *        The job name for the user import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job ID for the user import job.
         * </p>
         * 
         * @param jobId
         *        The job ID for the user import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The user pool ID for the user pool that the users are being imported into.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID for the user pool that the users are being imported into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The pre-signed URL to be used to upload the <code>.csv</code> file.
         * </p>
         * 
         * @param preSignedUrl
         *        The pre-signed URL to be used to upload the <code>.csv</code> file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(String preSignedUrl);

        /**
         * <p>
         * The date the user import job was created.
         * </p>
         * 
         * @param creationDate
         *        The date the user import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the user import job was started.
         * </p>
         * 
         * @param startDate
         *        The date when the user import job was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date when the user import job was completed.
         * </p>
         * 
         * @param completionDate
         *        The date when the user import job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * <p>
         * The status of the user import job. One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Created</code> - The job was created but not started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users
         * yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code> - The job has started, and users are being imported.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Succeeded</code> - The job has completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The job has stopped due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated
         * with the job was deleted, and the job cannot be started.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the user import job. One of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Created</code> - The job was created but not started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code> - A transition state. You have started the job, but it has not begun importing
         *        users yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code> - The job has started, and users are being imported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Succeeded</code> - The job has completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The job has stopped due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data
         *        associated with the job was deleted, and the job cannot be started.
         *        </p>
         *        </li>
         * @see UserImportJobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserImportJobStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the user import job. One of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Created</code> - The job was created but not started.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pending</code> - A transition state. You have started the job, but it has not begun importing users
         * yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code> - The job has started, and users are being imported.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Succeeded</code> - The job has completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code> - The job has stopped due to an error.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data associated
         * with the job was deleted, and the job cannot be started.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the user import job. One of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Created</code> - The job was created but not started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pending</code> - A transition state. You have started the job, but it has not begun importing
         *        users yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code> - The job has started, and users are being imported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopping</code> - You have stopped the job, but the job has not stopped importing users yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stopped</code> - You have stopped the job, and the job has stopped importing users.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Succeeded</code> - The job has completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code> - The job has stopped due to an error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Expired</code> - You created a job, but did not start the job within 24-48 hours. All data
         *        associated with the job was deleted, and the job cannot be started.
         *        </p>
         *        </li>
         * @see UserImportJobStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserImportJobStatusType
         */
        Builder status(UserImportJobStatusType status);

        /**
         * <p>
         * The role ARN for the Amazon CloudWatch Logging role for the user import job. For more information, see
         * "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        The role ARN for the Amazon CloudWatch Logging role for the user import job. For more information, see
         *        "Creating the CloudWatch Logs IAM Role" in the Amazon Cognito Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);

        /**
         * <p>
         * The number of users that were successfully imported.
         * </p>
         * 
         * @param importedUsers
         *        The number of users that were successfully imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedUsers(Long importedUsers);

        /**
         * <p>
         * The number of users that were skipped.
         * </p>
         * 
         * @param skippedUsers
         *        The number of users that were skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skippedUsers(Long skippedUsers);

        /**
         * <p>
         * The number of users that could not be imported.
         * </p>
         * 
         * @param failedUsers
         *        The number of users that could not be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedUsers(Long failedUsers);

        /**
         * <p>
         * The message returned when the user import job is completed.
         * </p>
         * 
         * @param completionMessage
         *        The message returned when the user import job is completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionMessage(String completionMessage);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobId;

        private String userPoolId;

        private String preSignedUrl;

        private Instant creationDate;

        private Instant startDate;

        private Instant completionDate;

        private String status;

        private String cloudWatchLogsRoleArn;

        private Long importedUsers;

        private Long skippedUsers;

        private Long failedUsers;

        private String completionMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UserImportJobType model) {
            jobName(model.jobName);
            jobId(model.jobId);
            userPoolId(model.userPoolId);
            preSignedUrl(model.preSignedUrl);
            creationDate(model.creationDate);
            startDate(model.startDate);
            completionDate(model.completionDate);
            status(model.status);
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            importedUsers(model.importedUsers);
            skippedUsers(model.skippedUsers);
            failedUsers(model.failedUsers);
            completionMessage(model.completionMessage);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getPreSignedUrl() {
            return preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserImportJobStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        public final Long getImportedUsers() {
            return importedUsers;
        }

        @Override
        public final Builder importedUsers(Long importedUsers) {
            this.importedUsers = importedUsers;
            return this;
        }

        public final void setImportedUsers(Long importedUsers) {
            this.importedUsers = importedUsers;
        }

        public final Long getSkippedUsers() {
            return skippedUsers;
        }

        @Override
        public final Builder skippedUsers(Long skippedUsers) {
            this.skippedUsers = skippedUsers;
            return this;
        }

        public final void setSkippedUsers(Long skippedUsers) {
            this.skippedUsers = skippedUsers;
        }

        public final Long getFailedUsers() {
            return failedUsers;
        }

        @Override
        public final Builder failedUsers(Long failedUsers) {
            this.failedUsers = failedUsers;
            return this;
        }

        public final void setFailedUsers(Long failedUsers) {
            this.failedUsers = failedUsers;
        }

        public final String getCompletionMessage() {
            return completionMessage;
        }

        @Override
        public final Builder completionMessage(String completionMessage) {
            this.completionMessage = completionMessage;
            return this;
        }

        public final void setCompletionMessage(String completionMessage) {
            this.completionMessage = completionMessage;
        }

        @Override
        public UserImportJobType build() {
            return new UserImportJobType(this);
        }
    }
}
