/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server for the request to update user attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserAttributesResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<UpdateUserAttributesResponse.Builder, UpdateUserAttributesResponse> {
    private final List<CodeDeliveryDetailsType> codeDeliveryDetailsList;

    private UpdateUserAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.codeDeliveryDetailsList = builder.codeDeliveryDetailsList;
    }

    /**
     * <p>
     * The code delivery details list from the server for the request to update user attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The code delivery details list from the server for the request to update user attributes.
     */
    public List<CodeDeliveryDetailsType> codeDeliveryDetailsList() {
        return codeDeliveryDetailsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeDeliveryDetailsList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAttributesResponse)) {
            return false;
        }
        UpdateUserAttributesResponse other = (UpdateUserAttributesResponse) obj;
        return Objects.equals(codeDeliveryDetailsList(), other.codeDeliveryDetailsList());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateUserAttributesResponse").add("CodeDeliveryDetailsList", codeDeliveryDetailsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeDeliveryDetailsList":
            return Optional.ofNullable(clazz.cast(codeDeliveryDetailsList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder,
            CopyableBuilder<Builder, UpdateUserAttributesResponse> {
        /**
         * <p>
         * The code delivery details list from the server for the request to update user attributes.
         * </p>
         * 
         * @param codeDeliveryDetailsList
         *        The code delivery details list from the server for the request to update user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeliveryDetailsList(Collection<CodeDeliveryDetailsType> codeDeliveryDetailsList);

        /**
         * <p>
         * The code delivery details list from the server for the request to update user attributes.
         * </p>
         * 
         * @param codeDeliveryDetailsList
         *        The code delivery details list from the server for the request to update user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeliveryDetailsList(CodeDeliveryDetailsType... codeDeliveryDetailsList);

        /**
         * <p>
         * The code delivery details list from the server for the request to update user attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeDeliveryDetailsType>.Builder} avoiding
         * the need to create one manually via {@link List<CodeDeliveryDetailsType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeDeliveryDetailsType>.Builder#build()} is called
         * immediately and its result is passed to {@link #codeDeliveryDetailsList(List<CodeDeliveryDetailsType>)}.
         * 
         * @param codeDeliveryDetailsList
         *        a consumer that will call methods on {@link List<CodeDeliveryDetailsType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeDeliveryDetailsList(List<CodeDeliveryDetailsType>)
         */
        Builder codeDeliveryDetailsList(Consumer<CodeDeliveryDetailsType.Builder>... codeDeliveryDetailsList);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<CodeDeliveryDetailsType> codeDeliveryDetailsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserAttributesResponse model) {
            super(model);
            codeDeliveryDetailsList(model.codeDeliveryDetailsList);
        }

        public final Collection<CodeDeliveryDetailsType.Builder> getCodeDeliveryDetailsList() {
            return codeDeliveryDetailsList != null ? codeDeliveryDetailsList.stream().map(CodeDeliveryDetailsType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder codeDeliveryDetailsList(Collection<CodeDeliveryDetailsType> codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList = CodeDeliveryDetailsListTypeCopier.copy(codeDeliveryDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeDeliveryDetailsList(CodeDeliveryDetailsType... codeDeliveryDetailsList) {
            codeDeliveryDetailsList(Arrays.asList(codeDeliveryDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeDeliveryDetailsList(Consumer<CodeDeliveryDetailsType.Builder>... codeDeliveryDetailsList) {
            codeDeliveryDetailsList(Stream.of(codeDeliveryDetailsList)
                    .map(c -> CodeDeliveryDetailsType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCodeDeliveryDetailsList(Collection<CodeDeliveryDetailsType.BuilderImpl> codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList = CodeDeliveryDetailsListTypeCopier.copyFromBuilder(codeDeliveryDetailsList);
        }

        @Override
        public UpdateUserAttributesResponse build() {
            return new UpdateUserAttributesResponse(this);
        }
    }
}
