/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.SmsConfigurationTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SMS configuration type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsConfigurationType implements StructuredPojo,
        ToCopyableBuilder<SmsConfigurationType.Builder, SmsConfigurationType> {
    private final String snsCallerArn;

    private final String externalId;

    private SmsConfigurationType(BuilderImpl builder) {
        this.snsCallerArn = builder.snsCallerArn;
        this.externalId = builder.externalId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller.
     */
    public String snsCallerArn() {
        return snsCallerArn;
    }

    /**
     * <p>
     * The external ID.
     * </p>
     * 
     * @return The external ID.
     */
    public String externalId() {
        return externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsCallerArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsConfigurationType)) {
            return false;
        }
        SmsConfigurationType other = (SmsConfigurationType) obj;
        return Objects.equals(snsCallerArn(), other.snsCallerArn()) && Objects.equals(externalId(), other.externalId());
    }

    @Override
    public String toString() {
        return ToString.builder("SmsConfigurationType").add("SnsCallerArn", snsCallerArn()).add("ExternalId", externalId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsCallerArn":
            return Optional.ofNullable(clazz.cast(snsCallerArn()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SmsConfigurationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SmsConfigurationType> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller.
         * </p>
         * 
         * @param snsCallerArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsCallerArn(String snsCallerArn);

        /**
         * <p>
         * The external ID.
         * </p>
         * 
         * @param externalId
         *        The external ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);
    }

    static final class BuilderImpl implements Builder {
        private String snsCallerArn;

        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsConfigurationType model) {
            snsCallerArn(model.snsCallerArn);
            externalId(model.externalId);
        }

        public final String getSnsCallerArn() {
            return snsCallerArn;
        }

        @Override
        public final Builder snsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
            return this;
        }

        public final void setSnsCallerArn(String snsCallerArn) {
            this.snsCallerArn = snsCallerArn;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public SmsConfigurationType build() {
            return new SmsConfigurationType(this);
        }
    }
}
