/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.ProviderUserIdentifierTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for information about an identity provider for a user pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderUserIdentifierType implements StructuredPojo,
        ToCopyableBuilder<ProviderUserIdentifierType.Builder, ProviderUserIdentifierType> {
    private final String providerName;

    private final String providerAttributeName;

    private final String providerAttributeValue;

    private ProviderUserIdentifierType(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.providerAttributeName = builder.providerAttributeName;
        this.providerAttributeValue = builder.providerAttributeValue;
    }

    /**
     * <p>
     * The name of the provider, for example, Facebook, Google, or Login with Amazon.
     * </p>
     * 
     * @return The name of the provider, for example, Facebook, Google, or Login with Amazon.
     */
    public String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The name of the provider attribute to link to, for example, <code>NameID</code>.
     * </p>
     * 
     * @return The name of the provider attribute to link to, for example, <code>NameID</code>.
     */
    public String providerAttributeName() {
        return providerAttributeName;
    }

    /**
     * <p>
     * The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
     * </p>
     * 
     * @return The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
     */
    public String providerAttributeValue() {
        return providerAttributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(providerAttributeValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderUserIdentifierType)) {
            return false;
        }
        ProviderUserIdentifierType other = (ProviderUserIdentifierType) obj;
        return Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerAttributeName(), other.providerAttributeName())
                && Objects.equals(providerAttributeValue(), other.providerAttributeValue());
    }

    @Override
    public String toString() {
        return ToString.builder("ProviderUserIdentifierType").add("ProviderName", providerName())
                .add("ProviderAttributeName", providerAttributeName()).add("ProviderAttributeValue", providerAttributeValue())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ProviderAttributeName":
            return Optional.ofNullable(clazz.cast(providerAttributeName()));
        case "ProviderAttributeValue":
            return Optional.ofNullable(clazz.cast(providerAttributeValue()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProviderUserIdentifierTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ProviderUserIdentifierType> {
        /**
         * <p>
         * The name of the provider, for example, Facebook, Google, or Login with Amazon.
         * </p>
         * 
         * @param providerName
         *        The name of the provider, for example, Facebook, Google, or Login with Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The name of the provider attribute to link to, for example, <code>NameID</code>.
         * </p>
         * 
         * @param providerAttributeName
         *        The name of the provider attribute to link to, for example, <code>NameID</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerAttributeName(String providerAttributeName);

        /**
         * <p>
         * The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
         * </p>
         * 
         * @param providerAttributeValue
         *        The value of the provider attribute to link to, for example, <code>xxxxx_account</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerAttributeValue(String providerAttributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String providerName;

        private String providerAttributeName;

        private String providerAttributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderUserIdentifierType model) {
            providerName(model.providerName);
            providerAttributeName(model.providerAttributeName);
            providerAttributeValue(model.providerAttributeValue);
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getProviderAttributeName() {
            return providerAttributeName;
        }

        @Override
        public final Builder providerAttributeName(String providerAttributeName) {
            this.providerAttributeName = providerAttributeName;
            return this;
        }

        public final void setProviderAttributeName(String providerAttributeName) {
            this.providerAttributeName = providerAttributeName;
        }

        public final String getProviderAttributeValue() {
            return providerAttributeValue;
        }

        @Override
        public final Builder providerAttributeValue(String providerAttributeValue) {
            this.providerAttributeValue = providerAttributeValue;
            return this;
        }

        public final void setProviderAttributeValue(String providerAttributeValue) {
            this.providerAttributeValue = providerAttributeValue;
        }

        @Override
        public ProviderUserIdentifierType build() {
            return new ProviderUserIdentifierType(this);
        }
    }
}
