/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.MessageTemplateTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The message template structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTemplateType implements StructuredPojo,
        ToCopyableBuilder<MessageTemplateType.Builder, MessageTemplateType> {
    private final String smsMessage;

    private final String emailMessage;

    private final String emailSubject;

    private MessageTemplateType(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
    }

    /**
     * <p>
     * The message template for SMS messages.
     * </p>
     * 
     * @return The message template for SMS messages.
     */
    public String smsMessage() {
        return smsMessage;
    }

    /**
     * <p>
     * The message template for email messages.
     * </p>
     * 
     * @return The message template for email messages.
     */
    public String emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * The subject line for email messages.
     * </p>
     * 
     * @return The subject line for email messages.
     */
    public String emailSubject() {
        return emailSubject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailSubject());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateType)) {
            return false;
        }
        MessageTemplateType other = (MessageTemplateType) obj;
        return Objects.equals(smsMessage(), other.smsMessage()) && Objects.equals(emailMessage(), other.emailMessage())
                && Objects.equals(emailSubject(), other.emailSubject());
    }

    @Override
    public String toString() {
        return ToString.builder("MessageTemplateType").add("SMSMessage", smsMessage()).add("EmailMessage", emailMessage())
                .add("EmailSubject", emailSubject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SMSMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "EmailSubject":
            return Optional.ofNullable(clazz.cast(emailSubject()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageTemplateTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MessageTemplateType> {
        /**
         * <p>
         * The message template for SMS messages.
         * </p>
         * 
         * @param smsMessage
         *        The message template for SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(String smsMessage);

        /**
         * <p>
         * The message template for email messages.
         * </p>
         * 
         * @param emailMessage
         *        The message template for email messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(String emailMessage);

        /**
         * <p>
         * The subject line for email messages.
         * </p>
         * 
         * @param emailSubject
         *        The subject line for email messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailSubject(String emailSubject);
    }

    static final class BuilderImpl implements Builder {
        private String smsMessage;

        private String emailMessage;

        private String emailSubject;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateType model) {
            smsMessage(model.smsMessage);
            emailMessage(model.emailMessage);
            emailSubject(model.emailSubject);
        }

        public final String getSMSMessage() {
            return smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSMSMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        public final String getEmailMessage() {
            return emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        public final String getEmailSubject() {
            return emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        @Override
        public MessageTemplateType build() {
            return new MessageTemplateType(this);
        }
    }
}
