/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.LambdaConfigTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the type of configuration for AWS Lambda triggers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaConfigType implements StructuredPojo, ToCopyableBuilder<LambdaConfigType.Builder, LambdaConfigType> {
    private final String preSignUp;

    private final String customMessage;

    private final String postConfirmation;

    private final String preAuthentication;

    private final String postAuthentication;

    private final String defineAuthChallenge;

    private final String createAuthChallenge;

    private final String verifyAuthChallengeResponse;

    private LambdaConfigType(BuilderImpl builder) {
        this.preSignUp = builder.preSignUp;
        this.customMessage = builder.customMessage;
        this.postConfirmation = builder.postConfirmation;
        this.preAuthentication = builder.preAuthentication;
        this.postAuthentication = builder.postAuthentication;
        this.defineAuthChallenge = builder.defineAuthChallenge;
        this.createAuthChallenge = builder.createAuthChallenge;
        this.verifyAuthChallengeResponse = builder.verifyAuthChallengeResponse;
    }

    /**
     * <p>
     * A pre-registration AWS Lambda trigger.
     * </p>
     * 
     * @return A pre-registration AWS Lambda trigger.
     */
    public String preSignUp() {
        return preSignUp;
    }

    /**
     * <p>
     * A custom Message AWS Lambda trigger.
     * </p>
     * 
     * @return A custom Message AWS Lambda trigger.
     */
    public String customMessage() {
        return customMessage;
    }

    /**
     * <p>
     * A post-confirmation AWS Lambda trigger.
     * </p>
     * 
     * @return A post-confirmation AWS Lambda trigger.
     */
    public String postConfirmation() {
        return postConfirmation;
    }

    /**
     * <p>
     * A pre-authentication AWS Lambda trigger.
     * </p>
     * 
     * @return A pre-authentication AWS Lambda trigger.
     */
    public String preAuthentication() {
        return preAuthentication;
    }

    /**
     * <p>
     * A post-authentication AWS Lambda trigger.
     * </p>
     * 
     * @return A post-authentication AWS Lambda trigger.
     */
    public String postAuthentication() {
        return postAuthentication;
    }

    /**
     * <p>
     * Defines the authentication challenge.
     * </p>
     * 
     * @return Defines the authentication challenge.
     */
    public String defineAuthChallenge() {
        return defineAuthChallenge;
    }

    /**
     * <p>
     * Creates an authentication challenge.
     * </p>
     * 
     * @return Creates an authentication challenge.
     */
    public String createAuthChallenge() {
        return createAuthChallenge;
    }

    /**
     * <p>
     * Verifies the authentication challenge response.
     * </p>
     * 
     * @return Verifies the authentication challenge response.
     */
    public String verifyAuthChallengeResponse() {
        return verifyAuthChallengeResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preSignUp());
        hashCode = 31 * hashCode + Objects.hashCode(customMessage());
        hashCode = 31 * hashCode + Objects.hashCode(postConfirmation());
        hashCode = 31 * hashCode + Objects.hashCode(preAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(postAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(defineAuthChallenge());
        hashCode = 31 * hashCode + Objects.hashCode(createAuthChallenge());
        hashCode = 31 * hashCode + Objects.hashCode(verifyAuthChallengeResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaConfigType)) {
            return false;
        }
        LambdaConfigType other = (LambdaConfigType) obj;
        return Objects.equals(preSignUp(), other.preSignUp()) && Objects.equals(customMessage(), other.customMessage())
                && Objects.equals(postConfirmation(), other.postConfirmation())
                && Objects.equals(preAuthentication(), other.preAuthentication())
                && Objects.equals(postAuthentication(), other.postAuthentication())
                && Objects.equals(defineAuthChallenge(), other.defineAuthChallenge())
                && Objects.equals(createAuthChallenge(), other.createAuthChallenge())
                && Objects.equals(verifyAuthChallengeResponse(), other.verifyAuthChallengeResponse());
    }

    @Override
    public String toString() {
        return ToString.builder("LambdaConfigType").add("PreSignUp", preSignUp()).add("CustomMessage", customMessage())
                .add("PostConfirmation", postConfirmation()).add("PreAuthentication", preAuthentication())
                .add("PostAuthentication", postAuthentication()).add("DefineAuthChallenge", defineAuthChallenge())
                .add("CreateAuthChallenge", createAuthChallenge())
                .add("VerifyAuthChallengeResponse", verifyAuthChallengeResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreSignUp":
            return Optional.ofNullable(clazz.cast(preSignUp()));
        case "CustomMessage":
            return Optional.ofNullable(clazz.cast(customMessage()));
        case "PostConfirmation":
            return Optional.ofNullable(clazz.cast(postConfirmation()));
        case "PreAuthentication":
            return Optional.ofNullable(clazz.cast(preAuthentication()));
        case "PostAuthentication":
            return Optional.ofNullable(clazz.cast(postAuthentication()));
        case "DefineAuthChallenge":
            return Optional.ofNullable(clazz.cast(defineAuthChallenge()));
        case "CreateAuthChallenge":
            return Optional.ofNullable(clazz.cast(createAuthChallenge()));
        case "VerifyAuthChallengeResponse":
            return Optional.ofNullable(clazz.cast(verifyAuthChallengeResponse()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaConfigTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaConfigType> {
        /**
         * <p>
         * A pre-registration AWS Lambda trigger.
         * </p>
         * 
         * @param preSignUp
         *        A pre-registration AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignUp(String preSignUp);

        /**
         * <p>
         * A custom Message AWS Lambda trigger.
         * </p>
         * 
         * @param customMessage
         *        A custom Message AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMessage(String customMessage);

        /**
         * <p>
         * A post-confirmation AWS Lambda trigger.
         * </p>
         * 
         * @param postConfirmation
         *        A post-confirmation AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postConfirmation(String postConfirmation);

        /**
         * <p>
         * A pre-authentication AWS Lambda trigger.
         * </p>
         * 
         * @param preAuthentication
         *        A pre-authentication AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preAuthentication(String preAuthentication);

        /**
         * <p>
         * A post-authentication AWS Lambda trigger.
         * </p>
         * 
         * @param postAuthentication
         *        A post-authentication AWS Lambda trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postAuthentication(String postAuthentication);

        /**
         * <p>
         * Defines the authentication challenge.
         * </p>
         * 
         * @param defineAuthChallenge
         *        Defines the authentication challenge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defineAuthChallenge(String defineAuthChallenge);

        /**
         * <p>
         * Creates an authentication challenge.
         * </p>
         * 
         * @param createAuthChallenge
         *        Creates an authentication challenge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createAuthChallenge(String createAuthChallenge);

        /**
         * <p>
         * Verifies the authentication challenge response.
         * </p>
         * 
         * @param verifyAuthChallengeResponse
         *        Verifies the authentication challenge response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifyAuthChallengeResponse(String verifyAuthChallengeResponse);
    }

    static final class BuilderImpl implements Builder {
        private String preSignUp;

        private String customMessage;

        private String postConfirmation;

        private String preAuthentication;

        private String postAuthentication;

        private String defineAuthChallenge;

        private String createAuthChallenge;

        private String verifyAuthChallengeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaConfigType model) {
            preSignUp(model.preSignUp);
            customMessage(model.customMessage);
            postConfirmation(model.postConfirmation);
            preAuthentication(model.preAuthentication);
            postAuthentication(model.postAuthentication);
            defineAuthChallenge(model.defineAuthChallenge);
            createAuthChallenge(model.createAuthChallenge);
            verifyAuthChallengeResponse(model.verifyAuthChallengeResponse);
        }

        public final String getPreSignUp() {
            return preSignUp;
        }

        @Override
        public final Builder preSignUp(String preSignUp) {
            this.preSignUp = preSignUp;
            return this;
        }

        public final void setPreSignUp(String preSignUp) {
            this.preSignUp = preSignUp;
        }

        public final String getCustomMessage() {
            return customMessage;
        }

        @Override
        public final Builder customMessage(String customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public final void setCustomMessage(String customMessage) {
            this.customMessage = customMessage;
        }

        public final String getPostConfirmation() {
            return postConfirmation;
        }

        @Override
        public final Builder postConfirmation(String postConfirmation) {
            this.postConfirmation = postConfirmation;
            return this;
        }

        public final void setPostConfirmation(String postConfirmation) {
            this.postConfirmation = postConfirmation;
        }

        public final String getPreAuthentication() {
            return preAuthentication;
        }

        @Override
        public final Builder preAuthentication(String preAuthentication) {
            this.preAuthentication = preAuthentication;
            return this;
        }

        public final void setPreAuthentication(String preAuthentication) {
            this.preAuthentication = preAuthentication;
        }

        public final String getPostAuthentication() {
            return postAuthentication;
        }

        @Override
        public final Builder postAuthentication(String postAuthentication) {
            this.postAuthentication = postAuthentication;
            return this;
        }

        public final void setPostAuthentication(String postAuthentication) {
            this.postAuthentication = postAuthentication;
        }

        public final String getDefineAuthChallenge() {
            return defineAuthChallenge;
        }

        @Override
        public final Builder defineAuthChallenge(String defineAuthChallenge) {
            this.defineAuthChallenge = defineAuthChallenge;
            return this;
        }

        public final void setDefineAuthChallenge(String defineAuthChallenge) {
            this.defineAuthChallenge = defineAuthChallenge;
        }

        public final String getCreateAuthChallenge() {
            return createAuthChallenge;
        }

        @Override
        public final Builder createAuthChallenge(String createAuthChallenge) {
            this.createAuthChallenge = createAuthChallenge;
            return this;
        }

        public final void setCreateAuthChallenge(String createAuthChallenge) {
            this.createAuthChallenge = createAuthChallenge;
        }

        public final String getVerifyAuthChallengeResponse() {
            return verifyAuthChallengeResponse;
        }

        @Override
        public final Builder verifyAuthChallengeResponse(String verifyAuthChallengeResponse) {
            this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
            return this;
        }

        public final void setVerifyAuthChallengeResponse(String verifyAuthChallengeResponse) {
            this.verifyAuthChallengeResponse = verifyAuthChallengeResponse;
        }

        @Override
        public LambdaConfigType build() {
            return new LambdaConfigType(this);
        }
    }
}
