/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUiCustomizationResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetUiCustomizationResponse.Builder, GetUiCustomizationResponse> {
    private final UICustomizationType uiCustomization;

    private GetUiCustomizationResponse(BuilderImpl builder) {
        super(builder);
        this.uiCustomization = builder.uiCustomization;
    }

    /**
     * <p>
     * The UI customization information.
     * </p>
     * 
     * @return The UI customization information.
     */
    public UICustomizationType uiCustomization() {
        return uiCustomization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uiCustomization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUiCustomizationResponse)) {
            return false;
        }
        GetUiCustomizationResponse other = (GetUiCustomizationResponse) obj;
        return Objects.equals(uiCustomization(), other.uiCustomization());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUiCustomizationResponse").add("UICustomization", uiCustomization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UICustomization":
            return Optional.ofNullable(clazz.cast(uiCustomization()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder,
            CopyableBuilder<Builder, GetUiCustomizationResponse> {
        /**
         * <p>
         * The UI customization information.
         * </p>
         * 
         * @param uiCustomization
         *        The UI customization information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiCustomization(UICustomizationType uiCustomization);

        /**
         * <p>
         * The UI customization information.
         * </p>
         * This is a convenience that creates an instance of the {@link UICustomizationType.Builder} avoiding the need
         * to create one manually via {@link UICustomizationType#builder()}.
         *
         * When the {@link Consumer} completes, {@link UICustomizationType.Builder#build()} is called immediately and
         * its result is passed to {@link #uiCustomization(UICustomizationType)}.
         * 
         * @param uiCustomization
         *        a consumer that will call methods on {@link UICustomizationType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiCustomization(UICustomizationType)
         */
        default Builder uiCustomization(Consumer<UICustomizationType.Builder> uiCustomization) {
            return uiCustomization(UICustomizationType.builder().applyMutation(uiCustomization).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private UICustomizationType uiCustomization;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUiCustomizationResponse model) {
            super(model);
            uiCustomization(model.uiCustomization);
        }

        public final UICustomizationType.Builder getUICustomization() {
            return uiCustomization != null ? uiCustomization.toBuilder() : null;
        }

        @Override
        public final Builder uiCustomization(UICustomizationType uiCustomization) {
            this.uiCustomization = uiCustomization;
            return this;
        }

        public final void setUICustomization(UICustomizationType.BuilderImpl uiCustomization) {
            this.uiCustomization = uiCustomization != null ? uiCustomization.build() : null;
        }

        @Override
        public GetUiCustomizationResponse build() {
            return new GetUiCustomizationResponse(this);
        }
    }
}
