/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the device response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<GetDeviceResponse.Builder, GetDeviceResponse> {
    private final DeviceType device;

    private GetDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.device = builder.device;
    }

    /**
     * <p>
     * The device.
     * </p>
     * 
     * @return The device.
     */
    public DeviceType device() {
        return device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(device());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceResponse)) {
            return false;
        }
        GetDeviceResponse other = (GetDeviceResponse) obj;
        return Objects.equals(device(), other.device());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDeviceResponse").add("Device", device()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, CopyableBuilder<Builder, GetDeviceResponse> {
        /**
         * <p>
         * The device.
         * </p>
         * 
         * @param device
         *        The device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(DeviceType device);

        /**
         * <p>
         * The device.
         * </p>
         * This is a convenience that creates an instance of the {@link DeviceType.Builder} avoiding the need to create
         * one manually via {@link DeviceType#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceType.Builder#build()} is called immediately and its result
         * is passed to {@link #device(DeviceType)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link DeviceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(DeviceType)
         */
        default Builder device(Consumer<DeviceType.Builder> device) {
            return device(DeviceType.builder().applyMutation(device).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private DeviceType device;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceResponse model) {
            super(model);
            device(model.device);
        }

        public final DeviceType.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        @Override
        public final Builder device(DeviceType device) {
            this.device = device;
            return this;
        }

        public final void setDevice(DeviceType.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        public GetDeviceResponse build() {
            return new GetDeviceResponse(this);
        }
    }
}
