/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceServerResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<DescribeResourceServerResponse.Builder, DescribeResourceServerResponse> {
    private final ResourceServerType resourceServer;

    private DescribeResourceServerResponse(BuilderImpl builder) {
        super(builder);
        this.resourceServer = builder.resourceServer;
    }

    /**
     * <p>
     * The resource server.
     * </p>
     * 
     * @return The resource server.
     */
    public ResourceServerType resourceServer() {
        return resourceServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceServer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceServerResponse)) {
            return false;
        }
        DescribeResourceServerResponse other = (DescribeResourceServerResponse) obj;
        return Objects.equals(resourceServer(), other.resourceServer());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeResourceServerResponse").add("ResourceServer", resourceServer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceServer":
            return Optional.ofNullable(clazz.cast(resourceServer()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder,
            CopyableBuilder<Builder, DescribeResourceServerResponse> {
        /**
         * <p>
         * The resource server.
         * </p>
         * 
         * @param resourceServer
         *        The resource server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceServer(ResourceServerType resourceServer);

        /**
         * <p>
         * The resource server.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceServerType.Builder} avoiding the need to
         * create one manually via {@link ResourceServerType#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceServerType.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceServer(ResourceServerType)}.
         * 
         * @param resourceServer
         *        a consumer that will call methods on {@link ResourceServerType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceServer(ResourceServerType)
         */
        default Builder resourceServer(Consumer<ResourceServerType.Builder> resourceServer) {
            return resourceServer(ResourceServerType.builder().applyMutation(resourceServer).build());
        }
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private ResourceServerType resourceServer;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceServerResponse model) {
            super(model);
            resourceServer(model.resourceServer);
        }

        public final ResourceServerType.Builder getResourceServer() {
            return resourceServer != null ? resourceServer.toBuilder() : null;
        }

        @Override
        public final Builder resourceServer(ResourceServerType resourceServer) {
            this.resourceServer = resourceServer;
            return this;
        }

        public final void setResourceServer(ResourceServerType.BuilderImpl resourceServer) {
            this.resourceServer = resourceServer != null ? resourceServer.build() : null;
        }

        @Override
        public DescribeResourceServerResponse build() {
            return new DescribeResourceServerResponse(this);
        }
    }
}
