/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIdentityProviderRequest extends CognitoIdentityProviderRequest implements
        ToCopyableBuilder<CreateIdentityProviderRequest.Builder, CreateIdentityProviderRequest> {
    private final String userPoolId;

    private final String providerName;

    private final String providerType;

    private final Map<String, String> providerDetails;

    private final Map<String, String> attributeMapping;

    private final List<String> idpIdentifiers;

    private CreateIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.providerName = builder.providerName;
        this.providerType = builder.providerType;
        this.providerDetails = builder.providerDetails;
        this.attributeMapping = builder.attributeMapping;
        this.idpIdentifiers = builder.idpIdentifiers;
    }

    /**
     * <p>
     * The user pool ID.
     * </p>
     * 
     * @return The user pool ID.
     */
    public String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @return The identity provider name.
     */
    public String providerName() {
        return providerName;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link IdentityProviderTypeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderTypeType
     */
    public IdentityProviderTypeType providerType() {
        return IdentityProviderTypeType.fromValue(providerType);
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link IdentityProviderTypeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderTypeType
     */
    public String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The identity provider details, such as <code>MetadataURL</code> and <code>MetadataFile</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The identity provider details, such as <code>MetadataURL</code> and <code>MetadataFile</code>.
     */
    public Map<String, String> providerDetails() {
        return providerDetails;
    }

    /**
     * <p>
     * A mapping of identity provider attributes to standard and custom user pool attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A mapping of identity provider attributes to standard and custom user pool attributes.
     */
    public Map<String, String> attributeMapping() {
        return attributeMapping;
    }

    /**
     * <p>
     * A list of identity provider identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of identity provider identifiers.
     */
    public List<String> idpIdentifiers() {
        return idpIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(providerName());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(providerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(attributeMapping());
        hashCode = 31 * hashCode + Objects.hashCode(idpIdentifiers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityProviderRequest)) {
            return false;
        }
        CreateIdentityProviderRequest other = (CreateIdentityProviderRequest) obj;
        return Objects.equals(userPoolId(), other.userPoolId()) && Objects.equals(providerName(), other.providerName())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(providerDetails(), other.providerDetails())
                && Objects.equals(attributeMapping(), other.attributeMapping())
                && Objects.equals(idpIdentifiers(), other.idpIdentifiers());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateIdentityProviderRequest").add("UserPoolId", userPoolId())
                .add("ProviderName", providerName()).add("ProviderType", providerTypeAsString())
                .add("ProviderDetails", providerDetails()).add("AttributeMapping", attributeMapping())
                .add("IdpIdentifiers", idpIdentifiers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "ProviderName":
            return Optional.ofNullable(clazz.cast(providerName()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "ProviderDetails":
            return Optional.ofNullable(clazz.cast(providerDetails()));
        case "AttributeMapping":
            return Optional.ofNullable(clazz.cast(attributeMapping()));
        case "IdpIdentifiers":
            return Optional.ofNullable(clazz.cast(idpIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderRequest.Builder,
            CopyableBuilder<Builder, CreateIdentityProviderRequest> {
        /**
         * <p>
         * The user pool ID.
         * </p>
         * 
         * @param userPoolId
         *        The user pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * The identity provider name.
         * </p>
         * 
         * @param providerName
         *        The identity provider name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerName(String providerName);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param providerType
         *        The identity provider type.
         * @see IdentityProviderTypeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderTypeType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param providerType
         *        The identity provider type.
         * @see IdentityProviderTypeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderTypeType
         */
        Builder providerType(IdentityProviderTypeType providerType);

        /**
         * <p>
         * The identity provider details, such as <code>MetadataURL</code> and <code>MetadataFile</code>.
         * </p>
         * 
         * @param providerDetails
         *        The identity provider details, such as <code>MetadataURL</code> and <code>MetadataFile</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerDetails(Map<String, String> providerDetails);

        /**
         * <p>
         * A mapping of identity provider attributes to standard and custom user pool attributes.
         * </p>
         * 
         * @param attributeMapping
         *        A mapping of identity provider attributes to standard and custom user pool attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeMapping(Map<String, String> attributeMapping);

        /**
         * <p>
         * A list of identity provider identifiers.
         * </p>
         * 
         * @param idpIdentifiers
         *        A list of identity provider identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpIdentifiers(Collection<String> idpIdentifiers);

        /**
         * <p>
         * A list of identity provider identifiers.
         * </p>
         * 
         * @param idpIdentifiers
         *        A list of identity provider identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idpIdentifiers(String... idpIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityProviderRequest.BuilderImpl implements Builder {
        private String userPoolId;

        private String providerName;

        private String providerType;

        private Map<String, String> providerDetails = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> attributeMapping = DefaultSdkAutoConstructMap.getInstance();

        private List<String> idpIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentityProviderRequest model) {
            super(model);
            userPoolId(model.userPoolId);
            providerName(model.providerName);
            providerType(model.providerType);
            providerDetails(model.providerDetails);
            attributeMapping(model.attributeMapping);
            idpIdentifiers(model.idpIdentifiers);
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getProviderName() {
            return providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getProviderType() {
            return providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(IdentityProviderTypeType providerType) {
            this.providerType(providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final Map<String, String> getProviderDetails() {
            return providerDetails;
        }

        @Override
        public final Builder providerDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
            return this;
        }

        public final void setProviderDetails(Map<String, String> providerDetails) {
            this.providerDetails = ProviderDetailsTypeCopier.copy(providerDetails);
        }

        public final Map<String, String> getAttributeMapping() {
            return attributeMapping;
        }

        @Override
        public final Builder attributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
            return this;
        }

        public final void setAttributeMapping(Map<String, String> attributeMapping) {
            this.attributeMapping = AttributeMappingTypeCopier.copy(attributeMapping);
        }

        public final Collection<String> getIdpIdentifiers() {
            return idpIdentifiers;
        }

        @Override
        public final Builder idpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idpIdentifiers(String... idpIdentifiers) {
            idpIdentifiers(Arrays.asList(idpIdentifiers));
            return this;
        }

        public final void setIdpIdentifiers(Collection<String> idpIdentifiers) {
            this.idpIdentifiers = IdpIdentifiersListTypeCopier.copy(idpIdentifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdentityProviderRequest build() {
            return new CreateIdentityProviderRequest(this);
        }
    }
}
