/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.AuthenticationResultTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result type of the authentication result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationResultType implements StructuredPojo,
        ToCopyableBuilder<AuthenticationResultType.Builder, AuthenticationResultType> {
    private final String accessToken;

    private final Integer expiresIn;

    private final String tokenType;

    private final String refreshToken;

    private final String idToken;

    private final NewDeviceMetadataType newDeviceMetadata;

    private AuthenticationResultType(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.expiresIn = builder.expiresIn;
        this.tokenType = builder.tokenType;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
        this.newDeviceMetadata = builder.newDeviceMetadata;
    }

    /**
     * <p>
     * The access token of the authentication result.
     * </p>
     * 
     * @return The access token of the authentication result.
     */
    public String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The expiration period of the authentication result.
     * </p>
     * 
     * @return The expiration period of the authentication result.
     */
    public Integer expiresIn() {
        return expiresIn;
    }

    /**
     * <p>
     * The token type of the authentication result.
     * </p>
     * 
     * @return The token type of the authentication result.
     */
    public String tokenType() {
        return tokenType;
    }

    /**
     * <p>
     * The refresh token of the authentication result.
     * </p>
     * 
     * @return The refresh token of the authentication result.
     */
    public String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * The ID token of the authentication result.
     * </p>
     * 
     * @return The ID token of the authentication result.
     */
    public String idToken() {
        return idToken;
    }

    /**
     * <p>
     * The new device metadata from an authentication result.
     * </p>
     * 
     * @return The new device metadata from an authentication result.
     */
    public NewDeviceMetadataType newDeviceMetadata() {
        return newDeviceMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(idToken());
        hashCode = 31 * hashCode + Objects.hashCode(newDeviceMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationResultType)) {
            return false;
        }
        AuthenticationResultType other = (AuthenticationResultType) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(expiresIn(), other.expiresIn())
                && Objects.equals(tokenType(), other.tokenType()) && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(idToken(), other.idToken()) && Objects.equals(newDeviceMetadata(), other.newDeviceMetadata());
    }

    @Override
    public String toString() {
        return ToString.builder("AuthenticationResultType").add("AccessToken", accessToken()).add("ExpiresIn", expiresIn())
                .add("TokenType", tokenType()).add("RefreshToken", refreshToken()).add("IdToken", idToken())
                .add("NewDeviceMetadata", newDeviceMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "ExpiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        case "TokenType":
            return Optional.ofNullable(clazz.cast(tokenType()));
        case "RefreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "IdToken":
            return Optional.ofNullable(clazz.cast(idToken()));
        case "NewDeviceMetadata":
            return Optional.ofNullable(clazz.cast(newDeviceMetadata()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationResultTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AuthenticationResultType> {
        /**
         * <p>
         * The access token of the authentication result.
         * </p>
         * 
         * @param accessToken
         *        The access token of the authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The expiration period of the authentication result.
         * </p>
         * 
         * @param expiresIn
         *        The expiration period of the authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(Integer expiresIn);

        /**
         * <p>
         * The token type of the authentication result.
         * </p>
         * 
         * @param tokenType
         *        The token type of the authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenType(String tokenType);

        /**
         * <p>
         * The refresh token of the authentication result.
         * </p>
         * 
         * @param refreshToken
         *        The refresh token of the authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * The ID token of the authentication result.
         * </p>
         * 
         * @param idToken
         *        The ID token of the authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idToken(String idToken);

        /**
         * <p>
         * The new device metadata from an authentication result.
         * </p>
         * 
         * @param newDeviceMetadata
         *        The new device metadata from an authentication result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDeviceMetadata(NewDeviceMetadataType newDeviceMetadata);

        /**
         * <p>
         * The new device metadata from an authentication result.
         * </p>
         * This is a convenience that creates an instance of the {@link NewDeviceMetadataType.Builder} avoiding the need
         * to create one manually via {@link NewDeviceMetadataType#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewDeviceMetadataType.Builder#build()} is called immediately and
         * its result is passed to {@link #newDeviceMetadata(NewDeviceMetadataType)}.
         * 
         * @param newDeviceMetadata
         *        a consumer that will call methods on {@link NewDeviceMetadataType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newDeviceMetadata(NewDeviceMetadataType)
         */
        default Builder newDeviceMetadata(Consumer<NewDeviceMetadataType.Builder> newDeviceMetadata) {
            return newDeviceMetadata(NewDeviceMetadataType.builder().applyMutation(newDeviceMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private Integer expiresIn;

        private String tokenType;

        private String refreshToken;

        private String idToken;

        private NewDeviceMetadataType newDeviceMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationResultType model) {
            accessToken(model.accessToken);
            expiresIn(model.expiresIn);
            tokenType(model.tokenType);
            refreshToken(model.refreshToken);
            idToken(model.idToken);
            newDeviceMetadata(model.newDeviceMetadata);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final Integer getExpiresIn() {
            return expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        public final String getTokenType() {
            return tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public final String getIdToken() {
            return idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        public final NewDeviceMetadataType.Builder getNewDeviceMetadata() {
            return newDeviceMetadata != null ? newDeviceMetadata.toBuilder() : null;
        }

        @Override
        public final Builder newDeviceMetadata(NewDeviceMetadataType newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata;
            return this;
        }

        public final void setNewDeviceMetadata(NewDeviceMetadataType.BuilderImpl newDeviceMetadata) {
            this.newDeviceMetadata = newDeviceMetadata != null ? newDeviceMetadata.build() : null;
        }

        @Override
        public AuthenticationResultType build() {
            return new AuthenticationResultType(this);
        }
    }
}
