/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server from the request to get the specified user as an administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminGetUserResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<AdminGetUserResponse.Builder, AdminGetUserResponse> {
    private final String username;

    private final List<AttributeType> userAttributes;

    private final Instant userCreateDate;

    private final Instant userLastModifiedDate;

    private final Boolean enabled;

    private final String userStatus;

    private final List<MFAOptionType> mfaOptions;

    private AdminGetUserResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.userCreateDate = builder.userCreateDate;
        this.userLastModifiedDate = builder.userLastModifiedDate;
        this.enabled = builder.enabled;
        this.userStatus = builder.userStatus;
        this.mfaOptions = builder.mfaOptions;
    }

    /**
     * <p>
     * The user name of the user about whom you are receiving information.
     * </p>
     * 
     * @return The user name of the user about whom you are receiving information.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * An array of name-value pairs representing user attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of name-value pairs representing user attributes.
     */
    public List<AttributeType> userAttributes() {
        return userAttributes;
    }

    /**
     * <p>
     * The date the user was created.
     * </p>
     * 
     * @return The date the user was created.
     */
    public Instant userCreateDate() {
        return userCreateDate;
    }

    /**
     * <p>
     * The date the user was last modified.
     * </p>
     * 
     * @return The date the user was last modified.
     */
    public Instant userLastModifiedDate() {
        return userLastModifiedDate;
    }

    /**
     * <p>
     * Indicates that the status is enabled.
     * </p>
     * 
     * @return Indicates that the status is enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The user status. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNCONFIRMED - User has been created but not confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIRMED - User has been confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVED - User is no longer active.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPROMISED - User is disabled due to a potential security threat.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - User status is not known.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The user status. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNCONFIRMED - User has been created but not confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIRMED - User has been confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVED - User is no longer active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPROMISED - User is disabled due to a potential security threat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - User status is not known.
     *         </p>
     *         </li>
     * @see UserStatusType
     */
    public UserStatusType userStatus() {
        return UserStatusType.fromValue(userStatus);
    }

    /**
     * <p>
     * The user status. Can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * UNCONFIRMED - User has been created but not confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONFIRMED - User has been confirmed.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARCHIVED - User is no longer active.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPROMISED - User is disabled due to a potential security threat.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN - User status is not known.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userStatus} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userStatusAsString}.
     * </p>
     * 
     * @return The user status. Can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         UNCONFIRMED - User has been created but not confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONFIRMED - User has been confirmed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARCHIVED - User is no longer active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPROMISED - User is disabled due to a potential security threat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN - User status is not known.
     *         </p>
     *         </li>
     * @see UserStatusType
     */
    public String userStatusAsString() {
        return userStatus;
    }

    /**
     * <p>
     * Specifies the options for MFA (e.g., email or phone number).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Specifies the options for MFA (e.g., email or phone number).
     */
    public List<MFAOptionType> mfaOptions() {
        return mfaOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(userCreateDate());
        hashCode = 31 * hashCode + Objects.hashCode(userLastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(userStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mfaOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminGetUserResponse)) {
            return false;
        }
        AdminGetUserResponse other = (AdminGetUserResponse) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(userAttributes(), other.userAttributes())
                && Objects.equals(userCreateDate(), other.userCreateDate())
                && Objects.equals(userLastModifiedDate(), other.userLastModifiedDate())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(userStatusAsString(), other.userStatusAsString())
                && Objects.equals(mfaOptions(), other.mfaOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("AdminGetUserResponse").add("Username", username()).add("UserAttributes", userAttributes())
                .add("UserCreateDate", userCreateDate()).add("UserLastModifiedDate", userLastModifiedDate())
                .add("Enabled", enabled()).add("UserStatus", userStatusAsString()).add("MFAOptions", mfaOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UserAttributes":
            return Optional.ofNullable(clazz.cast(userAttributes()));
        case "UserCreateDate":
            return Optional.ofNullable(clazz.cast(userCreateDate()));
        case "UserLastModifiedDate":
            return Optional.ofNullable(clazz.cast(userLastModifiedDate()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "UserStatus":
            return Optional.ofNullable(clazz.cast(userStatusAsString()));
        case "MFAOptions":
            return Optional.ofNullable(clazz.cast(mfaOptions()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, CopyableBuilder<Builder, AdminGetUserResponse> {
        /**
         * <p>
         * The user name of the user about whom you are receiving information.
         * </p>
         * 
         * @param username
         *        The user name of the user about whom you are receiving information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * 
         * @param userAttributes
         *        An array of name-value pairs representing user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(Collection<AttributeType> userAttributes);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * 
         * @param userAttributes
         *        An array of name-value pairs representing user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributes(AttributeType... userAttributes);

        /**
         * <p>
         * An array of name-value pairs representing user attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeType>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeType>.Builder#build()} is called immediately and
         * its result is passed to {@link #userAttributes(List<AttributeType>)}.
         * 
         * @param userAttributes
         *        a consumer that will call methods on {@link List<AttributeType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributes(List<AttributeType>)
         */
        Builder userAttributes(Consumer<AttributeType.Builder>... userAttributes);

        /**
         * <p>
         * The date the user was created.
         * </p>
         * 
         * @param userCreateDate
         *        The date the user was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCreateDate(Instant userCreateDate);

        /**
         * <p>
         * The date the user was last modified.
         * </p>
         * 
         * @param userLastModifiedDate
         *        The date the user was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userLastModifiedDate(Instant userLastModifiedDate);

        /**
         * <p>
         * Indicates that the status is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates that the status is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The user status. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNCONFIRMED - User has been created but not confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIRMED - User has been confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVED - User is no longer active.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPROMISED - User is disabled due to a potential security threat.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - User status is not known.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userStatus
         *        The user status. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNCONFIRMED - User has been created but not confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIRMED - User has been confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVED - User is no longer active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPROMISED - User is disabled due to a potential security threat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - User status is not known.
         *        </p>
         *        </li>
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder userStatus(String userStatus);

        /**
         * <p>
         * The user status. Can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * UNCONFIRMED - User has been created but not confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONFIRMED - User has been confirmed.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARCHIVED - User is no longer active.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPROMISED - User is disabled due to a potential security threat.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN - User status is not known.
         * </p>
         * </li>
         * </ul>
         * 
         * @param userStatus
         *        The user status. Can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        UNCONFIRMED - User has been created but not confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONFIRMED - User has been confirmed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARCHIVED - User is no longer active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPROMISED - User is disabled due to a potential security threat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN - User status is not known.
         *        </p>
         *        </li>
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder userStatus(UserStatusType userStatus);

        /**
         * <p>
         * Specifies the options for MFA (e.g., email or phone number).
         * </p>
         * 
         * @param mfaOptions
         *        Specifies the options for MFA (e.g., email or phone number).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(Collection<MFAOptionType> mfaOptions);

        /**
         * <p>
         * Specifies the options for MFA (e.g., email or phone number).
         * </p>
         * 
         * @param mfaOptions
         *        Specifies the options for MFA (e.g., email or phone number).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mfaOptions(MFAOptionType... mfaOptions);

        /**
         * <p>
         * Specifies the options for MFA (e.g., email or phone number).
         * </p>
         * This is a convenience that creates an instance of the {@link List<MFAOptionType>.Builder} avoiding the need
         * to create one manually via {@link List<MFAOptionType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MFAOptionType>.Builder#build()} is called immediately and
         * its result is passed to {@link #mfaOptions(List<MFAOptionType>)}.
         * 
         * @param mfaOptions
         *        a consumer that will call methods on {@link List<MFAOptionType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mfaOptions(List<MFAOptionType>)
         */
        Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private String username;

        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();

        private Instant userCreateDate;

        private Instant userLastModifiedDate;

        private Boolean enabled;

        private String userStatus;

        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdminGetUserResponse model) {
            super(model);
            username(model.username);
            userAttributes(model.userAttributes);
            userCreateDate(model.userCreateDate);
            userLastModifiedDate(model.userLastModifiedDate);
            enabled(model.enabled);
            userStatus(model.userStatus);
            mfaOptions(model.mfaOptions);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            return userAttributes != null ? userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType... userAttributes) {
            userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder>... userAttributes) {
            userAttributes(Stream.of(userAttributes).map(c -> AttributeType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final Instant getUserCreateDate() {
            return userCreateDate;
        }

        @Override
        public final Builder userCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
            return this;
        }

        public final void setUserCreateDate(Instant userCreateDate) {
            this.userCreateDate = userCreateDate;
        }

        public final Instant getUserLastModifiedDate() {
            return userLastModifiedDate;
        }

        @Override
        public final Builder userLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
            return this;
        }

        public final void setUserLastModifiedDate(Instant userLastModifiedDate) {
            this.userLastModifiedDate = userLastModifiedDate;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getUserStatus() {
            return userStatus;
        }

        @Override
        public final Builder userStatus(String userStatus) {
            this.userStatus = userStatus;
            return this;
        }

        @Override
        public final Builder userStatus(UserStatusType userStatus) {
            this.userStatus(userStatus.toString());
            return this;
        }

        public final void setUserStatus(String userStatus) {
            this.userStatus = userStatus;
        }

        public final Collection<MFAOptionType.Builder> getMFAOptions() {
            return mfaOptions != null ? mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType... mfaOptions) {
            mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder>... mfaOptions) {
            mfaOptions(Stream.of(mfaOptions).map(c -> MFAOptionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMFAOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        @Override
        public AdminGetUserResponse build() {
            return new AdminGetUserResponse(this);
        }
    }
}
