/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServersListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceServersResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListResourceServersResponse> {
    private static final SdkField<List<ResourceServerType>> RESOURCE_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListResourceServersResponse.getter(ListResourceServersResponse::resourceServers)).setter(ListResourceServersResponse.setter(Builder::resourceServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceServerType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListResourceServersResponse.getter(ListResourceServersResponse::nextToken)).setter(ListResourceServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SERVERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceServerType> resourceServers;
    private final String nextToken;

    private ListResourceServersResponse(BuilderImpl builder) {
        super(builder);
        this.resourceServers = builder.resourceServers;
        this.nextToken = builder.nextToken;
    }

    public List<ResourceServerType> resourceServers() {
        return this.resourceServers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceServersResponse)) {
            return false;
        }
        ListResourceServersResponse other = (ListResourceServersResponse)((Object)obj);
        return Objects.equals(this.resourceServers(), other.resourceServers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListResourceServersResponse").add("ResourceServers", this.resourceServers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceServers": {
                return Optional.ofNullable(clazz.cast(this.resourceServers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceServersResponse, T> g) {
        return obj -> g.apply((ListResourceServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<ResourceServerType> resourceServers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceServersResponse model) {
            super(model);
            this.resourceServers(model.resourceServers);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourceServerType.Builder> getResourceServers() {
            return this.resourceServers != null ? (Collection)this.resourceServers.stream().map(ResourceServerType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceServers(Collection<ResourceServerType> resourceServers) {
            this.resourceServers = ResourceServersListTypeCopier.copy(resourceServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceServers(ResourceServerType ... resourceServers) {
            this.resourceServers(Arrays.asList(resourceServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceServers(Consumer<ResourceServerType.Builder> ... resourceServers) {
            this.resourceServers(Stream.of(resourceServers).map(c -> (ResourceServerType)((ResourceServerType.Builder)ResourceServerType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceServers(Collection<ResourceServerType.BuilderImpl> resourceServers) {
            this.resourceServers = ResourceServersListTypeCopier.copyFromBuilder(resourceServers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceServersResponse build() {
            return new ListResourceServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceServersResponse> {
        public Builder resourceServers(Collection<ResourceServerType> var1);

        public Builder resourceServers(ResourceServerType ... var1);

        public Builder resourceServers(Consumer<ResourceServerType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

