/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.IdentityProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIdentityProviderResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, DescribeIdentityProviderResponse> {
    private static final SdkField<IdentityProviderType> IDENTITY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeIdentityProviderResponse.getter(DescribeIdentityProviderResponse::identityProvider)).setter(DescribeIdentityProviderResponse.setter(Builder::identityProvider)).constructor(IdentityProviderType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_FIELD));
    private final IdentityProviderType identityProvider;

    private DescribeIdentityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.identityProvider = builder.identityProvider;
    }

    public IdentityProviderType identityProvider() {
        return this.identityProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProvider());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderResponse)) {
            return false;
        }
        DescribeIdentityProviderResponse other = (DescribeIdentityProviderResponse)((Object)obj);
        return Objects.equals(this.identityProvider(), other.identityProvider());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIdentityProviderResponse").add("IdentityProvider", (Object)this.identityProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityProvider": {
                return Optional.ofNullable(clazz.cast(this.identityProvider()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityProviderResponse, T> g) {
        return obj -> g.apply((DescribeIdentityProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private IdentityProviderType identityProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderResponse model) {
            super(model);
            this.identityProvider(model.identityProvider);
        }

        public final IdentityProviderType.Builder getIdentityProvider() {
            return this.identityProvider != null ? this.identityProvider.toBuilder() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProviderType identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final void setIdentityProvider(IdentityProviderType.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public DescribeIdentityProviderResponse build() {
            return new DescribeIdentityProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIdentityProviderResponse> {
        public Builder identityProvider(IdentityProviderType var1);

        default public Builder identityProvider(Consumer<IdentityProviderType.Builder> identityProvider) {
            return this.identityProvider((IdentityProviderType)((IdentityProviderType.Builder)IdentityProviderType.builder().applyMutation(identityProvider)).build());
        }
    }
}

