/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListResourceServersResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ResourceServerType;

public class ListResourceServersIterable
implements SdkIterable<ListResourceServersResponse> {
    private final CognitoIdentityProviderClient client;
    private final ListResourceServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceServersIterable(CognitoIdentityProviderClient client, ListResourceServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourceServersResponseFetcher();
    }

    public Iterator<ListResourceServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceServerType> resourceServers() {
        Function<ListResourceServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceServers() != null) {
                return response.resourceServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceServersResponseFetcher
    implements SyncPageFetcher<ListResourceServersResponse> {
        private ListResourceServersResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceServersResponse nextPage(ListResourceServersResponse previousPage) {
            if (previousPage == null) {
                return ListResourceServersIterable.this.client.listResourceServers(ListResourceServersIterable.this.firstRequest);
            }
            return ListResourceServersIterable.this.client.listResourceServers((ListResourceServersRequest)((Object)ListResourceServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

