/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CustomDomainConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DomainStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainDescriptionType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainDescriptionType> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDescriptionType.getter(DomainDescriptionType::userPoolId)).setter(DomainDescriptionType.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDescriptionType.getter(DomainDescriptionType::awsAccountId)).setter(DomainDescriptionType.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDescriptionType.getter(DomainDescriptionType::domain)).setter(DomainDescriptionType.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDescriptionType.getter(DomainDescriptionType::s3Bucket)).setter(DomainDescriptionType.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> CLOUD_FRONT_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDescriptionType.getter(DomainDescriptionType::cloudFrontDistribution)).setter(DomainDescriptionType.setter(Builder::cloudFrontDistribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDistribution").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDescriptionType.getter(DomainDescriptionType::version)).setter(DomainDescriptionType.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainDescriptionType.getter(DomainDescriptionType::statusAsString)).setter(DomainDescriptionType.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CustomDomainConfigType> CUSTOM_DOMAIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DomainDescriptionType.getter(DomainDescriptionType::customDomainConfig)).setter(DomainDescriptionType.setter(Builder::customDomainConfig)).constructor(CustomDomainConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, AWS_ACCOUNT_ID_FIELD, DOMAIN_FIELD, S3_BUCKET_FIELD, CLOUD_FRONT_DISTRIBUTION_FIELD, VERSION_FIELD, STATUS_FIELD, CUSTOM_DOMAIN_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userPoolId;
    private final String awsAccountId;
    private final String domain;
    private final String s3Bucket;
    private final String cloudFrontDistribution;
    private final String version;
    private final String status;
    private final CustomDomainConfigType customDomainConfig;

    private DomainDescriptionType(BuilderImpl builder) {
        this.userPoolId = builder.userPoolId;
        this.awsAccountId = builder.awsAccountId;
        this.domain = builder.domain;
        this.s3Bucket = builder.s3Bucket;
        this.cloudFrontDistribution = builder.cloudFrontDistribution;
        this.version = builder.version;
        this.status = builder.status;
        this.customDomainConfig = builder.customDomainConfig;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String domain() {
        return this.domain;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String cloudFrontDistribution() {
        return this.cloudFrontDistribution;
    }

    public String version() {
        return this.version;
    }

    public DomainStatusType status() {
        return DomainStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public CustomDomainConfigType customDomainConfig() {
        return this.customDomainConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDescriptionType)) {
            return false;
        }
        DomainDescriptionType other = (DomainDescriptionType)obj;
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.cloudFrontDistribution(), other.cloudFrontDistribution()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.customDomainConfig(), other.customDomainConfig());
    }

    public String toString() {
        return ToString.builder((String)"DomainDescriptionType").add("UserPoolId", (Object)this.userPoolId()).add("AWSAccountId", (Object)this.awsAccountId()).add("Domain", (Object)this.domain()).add("S3Bucket", (Object)this.s3Bucket()).add("CloudFrontDistribution", (Object)this.cloudFrontDistribution()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).add("CustomDomainConfig", (Object)this.customDomainConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "AWSAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "CloudFrontDistribution": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontDistribution()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CustomDomainConfig": {
                return Optional.ofNullable(clazz.cast(this.customDomainConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainDescriptionType, T> g) {
        return obj -> g.apply((DomainDescriptionType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userPoolId;
        private String awsAccountId;
        private String domain;
        private String s3Bucket;
        private String cloudFrontDistribution;
        private String version;
        private String status;
        private CustomDomainConfigType customDomainConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDescriptionType model) {
            this.userPoolId(model.userPoolId);
            this.awsAccountId(model.awsAccountId);
            this.domain(model.domain);
            this.s3Bucket(model.s3Bucket);
            this.cloudFrontDistribution(model.cloudFrontDistribution);
            this.version(model.version);
            this.status(model.status);
            this.customDomainConfig(model.customDomainConfig);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getCloudFrontDistribution() {
            return this.cloudFrontDistribution;
        }

        @Override
        public final Builder cloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
            return this;
        }

        public final void setCloudFrontDistribution(String cloudFrontDistribution) {
            this.cloudFrontDistribution = cloudFrontDistribution;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final CustomDomainConfigType.Builder getCustomDomainConfig() {
            return this.customDomainConfig != null ? this.customDomainConfig.toBuilder() : null;
        }

        @Override
        public final Builder customDomainConfig(CustomDomainConfigType customDomainConfig) {
            this.customDomainConfig = customDomainConfig;
            return this;
        }

        public final void setCustomDomainConfig(CustomDomainConfigType.BuilderImpl customDomainConfig) {
            this.customDomainConfig = customDomainConfig != null ? customDomainConfig.build() : null;
        }

        public DomainDescriptionType build() {
            return new DomainDescriptionType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainDescriptionType> {
        public Builder userPoolId(String var1);

        public Builder awsAccountId(String var1);

        public Builder domain(String var1);

        public Builder s3Bucket(String var1);

        public Builder cloudFrontDistribution(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(DomainStatusType var1);

        public Builder customDomainConfig(CustomDomainConfigType var1);

        default public Builder customDomainConfig(Consumer<CustomDomainConfigType.Builder> customDomainConfig) {
            return this.customDomainConfig((CustomDomainConfigType)((CustomDomainConfigType.Builder)CustomDomainConfigType.builder().applyMutation(customDomainConfig)).build());
        }
    }
}

