/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminListDevicesRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminListDevicesRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AdminListDevicesRequest.getter(AdminListDevicesRequest::userPoolId)).setter(AdminListDevicesRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AdminListDevicesRequest.getter(AdminListDevicesRequest::username)).setter(AdminListDevicesRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AdminListDevicesRequest.getter(AdminListDevicesRequest::limit)).setter(AdminListDevicesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AdminListDevicesRequest.getter(AdminListDevicesRequest::paginationToken)).setter(AdminListDevicesRequest.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, USERNAME_FIELD, LIMIT_FIELD, PAGINATION_TOKEN_FIELD));
    private final String userPoolId;
    private final String username;
    private final Integer limit;
    private final String paginationToken;

    private AdminListDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.username = builder.username;
        this.limit = builder.limit;
        this.paginationToken = builder.paginationToken;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String username() {
        return this.username;
    }

    public Integer limit() {
        return this.limit;
    }

    public String paginationToken() {
        return this.paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminListDevicesRequest)) {
            return false;
        }
        AdminListDevicesRequest other = (AdminListDevicesRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public String toString() {
        return ToString.builder((String)"AdminListDevicesRequest").add("UserPoolId", (Object)this.userPoolId()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("Limit", (Object)this.limit()).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminListDevicesRequest, T> g) {
        return obj -> g.apply((AdminListDevicesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String username;
        private Integer limit;
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminListDevicesRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.username(model.username);
            this.limit(model.limit);
            this.paginationToken(model.paginationToken);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminListDevicesRequest build() {
            return new AdminListDevicesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminListDevicesRequest> {
        public Builder userPoolId(String var1);

        public Builder username(String var1);

        public Builder limit(Integer var1);

        public Builder paginationToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

