/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the Amazon Data Firehose stream destination of user activity log export with advanced security
 * features.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirehoseConfigurationType implements SdkPojo, Serializable,
        ToCopyableBuilder<FirehoseConfigurationType.Builder, FirehoseConfigurationType> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(FirehoseConfigurationType::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private FirehoseConfigurationType(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
    }

    /**
     * <p>
     * The ARN of an Amazon Data Firehose stream that's the destination for advanced security features log export.
     * </p>
     * 
     * @return The ARN of an Amazon Data Firehose stream that's the destination for advanced security features log
     *         export.
     */
    public final String streamArn() {
        return streamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseConfigurationType)) {
            return false;
        }
        FirehoseConfigurationType other = (FirehoseConfigurationType) obj;
        return Objects.equals(streamArn(), other.streamArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirehoseConfigurationType").add("StreamArn", streamArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamArn", STREAM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirehoseConfigurationType, T> g) {
        return obj -> g.apply((FirehoseConfigurationType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirehoseConfigurationType> {
        /**
         * <p>
         * The ARN of an Amazon Data Firehose stream that's the destination for advanced security features log export.
         * </p>
         * 
         * @param streamArn
         *        The ARN of an Amazon Data Firehose stream that's the destination for advanced security features log
         *        export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseConfigurationType model) {
            streamArn(model.streamArn);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        @Override
        public FirehoseConfigurationType build() {
            return new FirehoseConfigurationType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
