/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.cognitoidentityprovider.auth.scheme.CognitoIdentityProviderAuthSchemeParams;
import software.amazon.awssdk.services.cognitoidentityprovider.auth.scheme.CognitoIdentityProviderAuthSchemeProvider;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class DefaultCognitoIdentityProviderAuthSchemeProvider implements CognitoIdentityProviderAuthSchemeProvider {
    private static final DefaultCognitoIdentityProviderAuthSchemeProvider DEFAULT = new DefaultCognitoIdentityProviderAuthSchemeProvider();

    private DefaultCognitoIdentityProviderAuthSchemeProvider() {
    }

    public static DefaultCognitoIdentityProviderAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(CognitoIdentityProviderAuthSchemeParams params) {
        List<AuthSchemeOption> options = new ArrayList<>();
        switch (params.operation()) {
        case "AssociateSoftwareToken":
        case "ChangePassword":
        case "CompleteWebAuthnRegistration":
        case "ConfirmDevice":
        case "ConfirmForgotPassword":
        case "ConfirmSignUp":
        case "DeleteUser":
        case "DeleteUserAttributes":
        case "DeleteWebAuthnCredential":
        case "ForgetDevice":
        case "ForgotPassword":
        case "GetDevice":
        case "GetUser":
        case "GetUserAttributeVerificationCode":
        case "GetUserAuthFactors":
        case "GlobalSignOut":
        case "InitiateAuth":
        case "ListDevices":
        case "ListWebAuthnCredentials":
        case "ResendConfirmationCode":
        case "RespondToAuthChallenge":
        case "RevokeToken":
        case "SetUserMFAPreference":
        case "SetUserSettings":
        case "SignUp":
        case "StartWebAuthnRegistration":
        case "UpdateAuthEventFeedback":
        case "UpdateDeviceStatus":
        case "UpdateUserAttributes":
        case "VerifySoftwareToken":
        case "VerifyUserAttribute":
            options.add(AuthSchemeOption.builder().schemeId("smithy.api#noAuth").build());
            break;
        default:
            options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4")
                    .putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, "cognito-idp")
                    .putSignerProperty(AwsV4HttpSigner.REGION_NAME, params.region().id()).build());
            break;
        }
        return Collections.unmodifiableList(options);
    }
}
