/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.WebAuthnAuthenticatorTransportsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebAuthnCredentialDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebAuthnCredentialDescription> {
    private static final SdkField<String> CREDENTIAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialId").getter(WebAuthnCredentialDescription.getter(WebAuthnCredentialDescription::credentialId)).setter(WebAuthnCredentialDescription.setter(Builder::credentialId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialId").build()}).build();
    private static final SdkField<String> FRIENDLY_CREDENTIAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FriendlyCredentialName").getter(WebAuthnCredentialDescription.getter(WebAuthnCredentialDescription::friendlyCredentialName)).setter(WebAuthnCredentialDescription.setter(Builder::friendlyCredentialName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FriendlyCredentialName").build()}).build();
    private static final SdkField<String> RELYING_PARTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelyingPartyId").getter(WebAuthnCredentialDescription.getter(WebAuthnCredentialDescription::relyingPartyId)).setter(WebAuthnCredentialDescription.setter(Builder::relyingPartyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelyingPartyId").build()}).build();
    private static final SdkField<String> AUTHENTICATOR_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticatorAttachment").getter(WebAuthnCredentialDescription.getter(WebAuthnCredentialDescription::authenticatorAttachment)).setter(WebAuthnCredentialDescription.setter(Builder::authenticatorAttachment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticatorAttachment").build()}).build();
    private static final SdkField<List<String>> AUTHENTICATOR_TRANSPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthenticatorTransports").getter(WebAuthnCredentialDescription.getter(WebAuthnCredentialDescription::authenticatorTransports)).setter(WebAuthnCredentialDescription.setter(Builder::authenticatorTransports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticatorTransports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(WebAuthnCredentialDescription.getter(WebAuthnCredentialDescription::createdAt)).setter(WebAuthnCredentialDescription.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_ID_FIELD, FRIENDLY_CREDENTIAL_NAME_FIELD, RELYING_PARTY_ID_FIELD, AUTHENTICATOR_ATTACHMENT_FIELD, AUTHENTICATOR_TRANSPORTS_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CredentialId", CREDENTIAL_ID_FIELD);
            this.put("FriendlyCredentialName", FRIENDLY_CREDENTIAL_NAME_FIELD);
            this.put("RelyingPartyId", RELYING_PARTY_ID_FIELD);
            this.put("AuthenticatorAttachment", AUTHENTICATOR_ATTACHMENT_FIELD);
            this.put("AuthenticatorTransports", AUTHENTICATOR_TRANSPORTS_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String credentialId;
    private final String friendlyCredentialName;
    private final String relyingPartyId;
    private final String authenticatorAttachment;
    private final List<String> authenticatorTransports;
    private final Instant createdAt;

    private WebAuthnCredentialDescription(BuilderImpl builder) {
        this.credentialId = builder.credentialId;
        this.friendlyCredentialName = builder.friendlyCredentialName;
        this.relyingPartyId = builder.relyingPartyId;
        this.authenticatorAttachment = builder.authenticatorAttachment;
        this.authenticatorTransports = builder.authenticatorTransports;
        this.createdAt = builder.createdAt;
    }

    public final String credentialId() {
        return this.credentialId;
    }

    public final String friendlyCredentialName() {
        return this.friendlyCredentialName;
    }

    public final String relyingPartyId() {
        return this.relyingPartyId;
    }

    public final String authenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    public final boolean hasAuthenticatorTransports() {
        return this.authenticatorTransports != null && !(this.authenticatorTransports instanceof SdkAutoConstructList);
    }

    public final List<String> authenticatorTransports() {
        return this.authenticatorTransports;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialId());
        hashCode = 31 * hashCode + Objects.hashCode(this.friendlyCredentialName());
        hashCode = 31 * hashCode + Objects.hashCode(this.relyingPartyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticatorAttachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticatorTransports() ? this.authenticatorTransports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebAuthnCredentialDescription)) {
            return false;
        }
        WebAuthnCredentialDescription other = (WebAuthnCredentialDescription)obj;
        return Objects.equals(this.credentialId(), other.credentialId()) && Objects.equals(this.friendlyCredentialName(), other.friendlyCredentialName()) && Objects.equals(this.relyingPartyId(), other.relyingPartyId()) && Objects.equals(this.authenticatorAttachment(), other.authenticatorAttachment()) && this.hasAuthenticatorTransports() == other.hasAuthenticatorTransports() && Objects.equals(this.authenticatorTransports(), other.authenticatorTransports()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"WebAuthnCredentialDescription").add("CredentialId", (Object)this.credentialId()).add("FriendlyCredentialName", (Object)this.friendlyCredentialName()).add("RelyingPartyId", (Object)this.relyingPartyId()).add("AuthenticatorAttachment", (Object)this.authenticatorAttachment()).add("AuthenticatorTransports", this.hasAuthenticatorTransports() ? this.authenticatorTransports() : null).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CredentialId": {
                return Optional.ofNullable(clazz.cast(this.credentialId()));
            }
            case "FriendlyCredentialName": {
                return Optional.ofNullable(clazz.cast(this.friendlyCredentialName()));
            }
            case "RelyingPartyId": {
                return Optional.ofNullable(clazz.cast(this.relyingPartyId()));
            }
            case "AuthenticatorAttachment": {
                return Optional.ofNullable(clazz.cast(this.authenticatorAttachment()));
            }
            case "AuthenticatorTransports": {
                return Optional.ofNullable(clazz.cast(this.authenticatorTransports()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WebAuthnCredentialDescription, T> g) {
        return obj -> g.apply((WebAuthnCredentialDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String credentialId;
        private String friendlyCredentialName;
        private String relyingPartyId;
        private String authenticatorAttachment;
        private List<String> authenticatorTransports = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(WebAuthnCredentialDescription model) {
            this.credentialId(model.credentialId);
            this.friendlyCredentialName(model.friendlyCredentialName);
            this.relyingPartyId(model.relyingPartyId);
            this.authenticatorAttachment(model.authenticatorAttachment);
            this.authenticatorTransports(model.authenticatorTransports);
            this.createdAt(model.createdAt);
        }

        public final String getCredentialId() {
            return this.credentialId;
        }

        public final void setCredentialId(String credentialId) {
            this.credentialId = credentialId;
        }

        @Override
        public final Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public final String getFriendlyCredentialName() {
            return this.friendlyCredentialName;
        }

        public final void setFriendlyCredentialName(String friendlyCredentialName) {
            this.friendlyCredentialName = friendlyCredentialName;
        }

        @Override
        public final Builder friendlyCredentialName(String friendlyCredentialName) {
            this.friendlyCredentialName = friendlyCredentialName;
            return this;
        }

        public final String getRelyingPartyId() {
            return this.relyingPartyId;
        }

        public final void setRelyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
        }

        @Override
        public final Builder relyingPartyId(String relyingPartyId) {
            this.relyingPartyId = relyingPartyId;
            return this;
        }

        public final String getAuthenticatorAttachment() {
            return this.authenticatorAttachment;
        }

        public final void setAuthenticatorAttachment(String authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
        }

        @Override
        public final Builder authenticatorAttachment(String authenticatorAttachment) {
            this.authenticatorAttachment = authenticatorAttachment;
            return this;
        }

        public final Collection<String> getAuthenticatorTransports() {
            if (this.authenticatorTransports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authenticatorTransports;
        }

        public final void setAuthenticatorTransports(Collection<String> authenticatorTransports) {
            this.authenticatorTransports = WebAuthnAuthenticatorTransportsListCopier.copy(authenticatorTransports);
        }

        @Override
        public final Builder authenticatorTransports(Collection<String> authenticatorTransports) {
            this.authenticatorTransports = WebAuthnAuthenticatorTransportsListCopier.copy(authenticatorTransports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticatorTransports(String ... authenticatorTransports) {
            this.authenticatorTransports(Arrays.asList(authenticatorTransports));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public WebAuthnCredentialDescription build() {
            return new WebAuthnCredentialDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebAuthnCredentialDescription> {
        public Builder credentialId(String var1);

        public Builder friendlyCredentialName(String var1);

        public Builder relyingPartyId(String var1);

        public Builder authenticatorAttachment(String var1);

        public Builder authenticatorTransports(Collection<String> var1);

        public Builder authenticatorTransports(String ... var1);

        public Builder createdAt(Instant var1);
    }
}

