/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CloudWatchLogsConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventSourceName;
import software.amazon.awssdk.services.cognitoidentityprovider.model.FirehoseConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LogLevel;
import software.amazon.awssdk.services.cognitoidentityprovider.model.S3ConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfigurationType> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(LogConfigurationType.getter(LogConfigurationType::logLevelAsString)).setter(LogConfigurationType.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(LogConfigurationType.getter(LogConfigurationType::eventSourceAsString)).setter(LogConfigurationType.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<CloudWatchLogsConfigurationType> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogsConfiguration").getter(LogConfigurationType.getter(LogConfigurationType::cloudWatchLogsConfiguration)).setter(LogConfigurationType.setter(Builder::cloudWatchLogsConfiguration)).constructor(CloudWatchLogsConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsConfiguration").build()}).build();
    private static final SdkField<S3ConfigurationType> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Configuration").getter(LogConfigurationType.getter(LogConfigurationType::s3Configuration)).setter(LogConfigurationType.setter(Builder::s3Configuration)).constructor(S3ConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final SdkField<FirehoseConfigurationType> FIREHOSE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirehoseConfiguration").getter(LogConfigurationType.getter(LogConfigurationType::firehoseConfiguration)).setter(LogConfigurationType.setter(Builder::firehoseConfiguration)).constructor(FirehoseConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirehoseConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD, EVENT_SOURCE_FIELD, CLOUD_WATCH_LOGS_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD, FIREHOSE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LogLevel", LOG_LEVEL_FIELD);
            this.put("EventSource", EVENT_SOURCE_FIELD);
            this.put("CloudWatchLogsConfiguration", CLOUD_WATCH_LOGS_CONFIGURATION_FIELD);
            this.put("S3Configuration", S3_CONFIGURATION_FIELD);
            this.put("FirehoseConfiguration", FIREHOSE_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String logLevel;
    private final String eventSource;
    private final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;
    private final S3ConfigurationType s3Configuration;
    private final FirehoseConfigurationType firehoseConfiguration;

    private LogConfigurationType(BuilderImpl builder) {
        this.logLevel = builder.logLevel;
        this.eventSource = builder.eventSource;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.s3Configuration = builder.s3Configuration;
        this.firehoseConfiguration = builder.firehoseConfiguration;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final EventSourceName eventSource() {
        return EventSourceName.fromValue(this.eventSource);
    }

    public final String eventSourceAsString() {
        return this.eventSource;
    }

    public final CloudWatchLogsConfigurationType cloudWatchLogsConfiguration() {
        return this.cloudWatchLogsConfiguration;
    }

    public final S3ConfigurationType s3Configuration() {
        return this.s3Configuration;
    }

    public final FirehoseConfigurationType firehoseConfiguration() {
        return this.firehoseConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehoseConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurationType)) {
            return false;
        }
        LogConfigurationType other = (LogConfigurationType)obj;
        return Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.eventSourceAsString(), other.eventSourceAsString()) && Objects.equals(this.cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.firehoseConfiguration(), other.firehoseConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfigurationType").add("LogLevel", (Object)this.logLevelAsString()).add("EventSource", (Object)this.eventSourceAsString()).add("CloudWatchLogsConfiguration", (Object)this.cloudWatchLogsConfiguration()).add("S3Configuration", (Object)this.s3Configuration()).add("FirehoseConfiguration", (Object)this.firehoseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSourceAsString()));
            }
            case "CloudWatchLogsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsConfiguration()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "FirehoseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.firehoseConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LogConfigurationType, T> g) {
        return obj -> g.apply((LogConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logLevel;
        private String eventSource;
        private CloudWatchLogsConfigurationType cloudWatchLogsConfiguration;
        private S3ConfigurationType s3Configuration;
        private FirehoseConfigurationType firehoseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfigurationType model) {
            this.logLevel(model.logLevel);
            this.eventSource(model.eventSource);
            this.cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            this.s3Configuration(model.s3Configuration);
            this.firehoseConfiguration(model.firehoseConfiguration);
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        @Override
        public final Builder eventSource(EventSourceName eventSource) {
            this.eventSource(eventSource == null ? null : eventSource.toString());
            return this;
        }

        public final CloudWatchLogsConfigurationType.Builder getCloudWatchLogsConfiguration() {
            return this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfigurationType.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final S3ConfigurationType.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3ConfigurationType.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3ConfigurationType s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final FirehoseConfigurationType.Builder getFirehoseConfiguration() {
            return this.firehoseConfiguration != null ? this.firehoseConfiguration.toBuilder() : null;
        }

        public final void setFirehoseConfiguration(FirehoseConfigurationType.BuilderImpl firehoseConfiguration) {
            this.firehoseConfiguration = firehoseConfiguration != null ? firehoseConfiguration.build() : null;
        }

        @Override
        public final Builder firehoseConfiguration(FirehoseConfigurationType firehoseConfiguration) {
            this.firehoseConfiguration = firehoseConfiguration;
            return this;
        }

        public LogConfigurationType build() {
            return new LogConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfigurationType> {
        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder eventSource(String var1);

        public Builder eventSource(EventSourceName var1);

        public Builder cloudWatchLogsConfiguration(CloudWatchLogsConfigurationType var1);

        default public Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfigurationType.Builder> cloudWatchLogsConfiguration) {
            return this.cloudWatchLogsConfiguration((CloudWatchLogsConfigurationType)((CloudWatchLogsConfigurationType.Builder)CloudWatchLogsConfigurationType.builder().applyMutation(cloudWatchLogsConfiguration)).build());
        }

        public Builder s3Configuration(S3ConfigurationType var1);

        default public Builder s3Configuration(Consumer<S3ConfigurationType.Builder> s3Configuration) {
            return this.s3Configuration((S3ConfigurationType)((S3ConfigurationType.Builder)S3ConfigurationType.builder().applyMutation(s3Configuration)).build());
        }

        public Builder firehoseConfiguration(FirehoseConfigurationType var1);

        default public Builder firehoseConfiguration(Consumer<FirehoseConfigurationType.Builder> firehoseConfiguration) {
            return this.firehoseConfiguration((FirehoseConfigurationType)((FirehoseConfigurationType.Builder)FirehoseConfigurationType.builder().applyMutation(firehoseConfiguration)).build());
        }
    }
}

