/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersInGroupRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, ListUsersInGroupRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(ListUsersInGroupRequest.getter(ListUsersInGroupRequest::userPoolId)).setter(ListUsersInGroupRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(ListUsersInGroupRequest.getter(ListUsersInGroupRequest::groupName)).setter(ListUsersInGroupRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListUsersInGroupRequest.getter(ListUsersInGroupRequest::limit)).setter(ListUsersInGroupRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUsersInGroupRequest.getter(ListUsersInGroupRequest::nextToken)).setter(ListUsersInGroupRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, GROUP_NAME_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserPoolId", USER_POOL_ID_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String userPoolId;
    private final String groupName;
    private final Integer limit;
    private final String nextToken;

    private ListUsersInGroupRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.groupName = builder.groupName;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersInGroupRequest)) {
            return false;
        }
        ListUsersInGroupRequest other = (ListUsersInGroupRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersInGroupRequest").add("UserPoolId", (Object)this.userPoolId()).add("GroupName", (Object)this.groupName()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListUsersInGroupRequest, T> g) {
        return obj -> g.apply((ListUsersInGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String groupName;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersInGroupRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.groupName(model.groupName);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListUsersInGroupRequest build() {
            return new ListUsersInGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsersInGroupRequest> {
        public Builder userPoolId(String var1);

        public Builder groupName(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

